/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.access;

import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.access.AccessAssertion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public final class AccessAssertionPersister {
    private static final String JSON_CLASS_NAME = "className";
    @Autowired
    private ApplicationContext applicationContext;

    public AccessAssertion unmarshal(JSONObject encodedAssertion) {
        try {
            String className = encodedAssertion.getString(JSON_CLASS_NAME);
            Class<?> assertionClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            AccessAssertion assertion = (AccessAssertion)this.applicationContext.getBean(assertionClass);
            assertion.unmarshal(encodedAssertion);
            return assertion;
        }
        catch (ClassNotFoundException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject marshal(AccessAssertion assertion) {
        JSONObject jsonObject = assertion.marshal();
        if (jsonObject.has(JSON_CLASS_NAME)) {
            throw new AssertionError((Object)("The toJson method in AccessAssertion: '" + assertion.getClass() + "' defined a JSON field " + JSON_CLASS_NAME + " which is a reserved keyword and is not permitted to be used in toJSON method"));
        }
        try {
            jsonObject.put(JSON_CLASS_NAME, (Object)assertion.getClass().getName());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }
}

