/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.JsonStyleParserHelper;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.opengis.filter.Filter;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.springframework.http.client.ClientHttpRequestFactory;

public final class MapfishJsonStyleVersion1 {
    public static final String DEFAULT_GEOM_ATT_NAME = "geometry";
    private static final String JSON_STYLE_PROPERTY = "styleProperty";
    private static final String DEFAULT_STYLE_PROPERTY = "_style";
    private final String geometryProperty;
    private final PJsonObject json;
    private final StyleBuilder sldStyleBuilder;
    private final JsonStyleParserHelper parserHelper;

    MapfishJsonStyleVersion1(@Nonnull PJsonObject json, @Nonnull StyleBuilder styleBuilder, @Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory requestFactory, @Nonnull String defaultGeomAttName) {
        this.json = json;
        this.sldStyleBuilder = styleBuilder;
        this.parserHelper = new JsonStyleParserHelper(configuration, requestFactory, this.sldStyleBuilder, true);
        this.geometryProperty = defaultGeomAttName;
    }

    Style parseStyle() {
        String styleProperty = this.json.optString(JSON_STYLE_PROPERTY, DEFAULT_STYLE_PROPERTY);
        List<Rule> styleRules = this.getStyleRules(styleProperty);
        return this.parserHelper.createStyle(styleRules);
    }

    private List<Rule> getStyleRules(String styleProperty) {
        ArrayList styleRules = Lists.newArrayListWithExpectedSize((int)this.json.size());
        Iterator<String> iterator = this.json.keys();
        while (iterator.hasNext()) {
            String styleKey = iterator.next();
            if (styleKey.equals(JSON_STYLE_PROPERTY) || styleKey.equals("version")) continue;
            PJsonObject styleJson = this.json.getJSONObject(styleKey);
            List<Rule> currentRules = this.createStyleRule(styleKey, styleJson, styleProperty);
            for (Rule currentRule : currentRules) {
                if (currentRule == null) continue;
                styleRules.add(currentRule);
            }
        }
        return styleRules;
    }

    private List<Rule> createStyleRule(String styleKey, PJsonObject styleJson, String styleProperty) {
        PointSymbolizer pointSymbolizer = this.parserHelper.createPointSymbolizer(styleJson);
        LineSymbolizer lineSymbolizer = this.parserHelper.createLineSymbolizer(styleJson);
        PolygonSymbolizer polygonSymbolizer = this.parserHelper.createPolygonSymbolizer(styleJson);
        TextSymbolizer textSymbolizer = this.parserHelper.createTextSymbolizer(styleJson);
        Filter propertyMatches = this.createFilter(styleKey, styleProperty);
        Rule textRule = null;
        if (textSymbolizer != null) {
            textRule = this.sldStyleBuilder.createRule((Symbolizer)textSymbolizer);
            if (propertyMatches != null) {
                textRule.setFilter(propertyMatches);
            }
            textRule.setName(styleKey + "_Text");
        }
        return Lists.newArrayList((Object[])new Rule[]{this.createGeometryFilteredRule((Symbolizer)pointSymbolizer, styleKey, styleProperty, Point.class, MultiPoint.class, GeometryCollection.class), this.createGeometryFilteredRule((Symbolizer)lineSymbolizer, styleKey, styleProperty, LineString.class, MultiLineString.class, LinearRing.class, GeometryCollection.class), this.createGeometryFilteredRule((Symbolizer)polygonSymbolizer, styleKey, styleProperty, Polygon.class, MultiPolygon.class, GeometryCollection.class), textRule});
    }

    @SafeVarargs
    private final Rule createGeometryFilteredRule(Symbolizer symb, String styleKey, String styleProperty, Class<? extends Geometry> ... geomClass) {
        if (symb != null) {
            Expression geomProperty = this.sldStyleBuilder.attributeExpression(this.geometryProperty);
            Function geometryTypeFunction = this.sldStyleBuilder.getFilterFactory().function("geometryType", new Expression[]{geomProperty});
            ArrayList geomOptions = Lists.newArrayListWithExpectedSize((int)geomClass.length);
            for (Class<? extends Geometry> requiredType : geomClass) {
                Expression expr = this.sldStyleBuilder.literalExpression(requiredType.getSimpleName());
                geomOptions.add(this.sldStyleBuilder.getFilterFactory().equals((Expression)geometryTypeFunction, expr));
            }
            Or ruleFilter = this.sldStyleBuilder.getFilterFactory().or((List)geomOptions);
            Filter propertyMatches = this.createFilter(styleKey, styleProperty);
            Rule rule = this.sldStyleBuilder.createRule(symb);
            if (propertyMatches != null) {
                ruleFilter = this.sldStyleBuilder.getFilterFactory().and(propertyMatches, (Filter)ruleFilter);
            }
            rule.setFilter((Filter)ruleFilter);
            rule.setName(styleKey + "_" + geomClass[0].getSimpleName());
            return rule;
        }
        return null;
    }

    @Nullable
    private Filter createFilter(String styleKey, String styleProperty) {
        if (Strings.isNullOrEmpty((String)styleProperty) || Strings.isNullOrEmpty((String)styleKey)) {
            return null;
        }
        Expression attributeExpression = this.sldStyleBuilder.attributeExpression(styleProperty);
        Expression valueExpression = this.sldStyleBuilder.literalExpression(styleKey);
        return this.sldStyleBuilder.getFilterFactory().equals(attributeExpression, valueExpression);
    }
}

