/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TilePreparationInfo;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.client.ClientHttpRequest;

public final class TilePreparationTask
implements Callable<TilePreparationInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TilePreparationTask.class);
    private final MapBounds bounds;
    private final Rectangle paintArea;
    private final MapfishMapContext transformer;
    private final TileCacheInformation tiledLayer;
    private final String jobId;
    private final MfClientHttpRequestFactory httpRequestFactory;
    private final HttpRequestCache requestCache;
    private Optional<Geometry> cachedRotatedMapBounds = null;

    public TilePreparationTask(@Nonnull MfClientHttpRequestFactory httpRequestFactory, @Nonnull MapfishMapContext transformer, @Nonnull TileCacheInformation tileCacheInfo, HttpRequestCache requestCache, @Nonnull String jobId) {
        this.requestCache = requestCache;
        this.bounds = transformer.getBounds();
        this.paintArea = new Rectangle(transformer.getMapSize());
        this.httpRequestFactory = httpRequestFactory;
        this.transformer = transformer;
        this.tiledLayer = tileCacheInfo;
        this.jobId = jobId;
    }

    @Override
    public TilePreparationInfo call() {
        try {
            MDC.put((String)"job_id", (String)this.jobId);
            ReferencedEnvelope mapGeoBounds = this.bounds.toReferencedEnvelope(this.paintArea);
            CoordinateReferenceSystem mapProjection = mapGeoBounds.getCoordinateReferenceSystem();
            Dimension tileSizeOnScreen = this.tiledLayer.getTileSize();
            double layerResolution = this.tiledLayer.getResolution();
            Coordinate tileSizeInWorld = new Coordinate((double)tileSizeOnScreen.width * layerResolution, (double)tileSizeOnScreen.height * layerResolution);
            Coordinate gridCoverageOrigin = this.tiledLayer.getMinGeoCoordinate(mapGeoBounds, tileSizeInWorld);
            String commonUrl = this.tiledLayer.createCommonUrl();
            ReferencedEnvelope tileCacheBounds = this.tiledLayer.getTileCacheBounds();
            double resolution = this.tiledLayer.getResolution();
            double rowFactor = 1.0 / (resolution * (double)tileSizeOnScreen.height);
            double columnFactor = 1.0 / (resolution * (double)tileSizeOnScreen.width);
            int imageWidth = 0;
            int imageHeight = 0;
            int yIndex = (int)Math.floor((mapGeoBounds.getMaxY() - gridCoverageOrigin.y) / tileSizeInWorld.y) + 1;
            double gridCoverageMaxX = gridCoverageOrigin.x;
            double gridCoverageMaxY = gridCoverageOrigin.y;
            ArrayList tiles = Lists.newArrayList();
            for (double geoY = gridCoverageOrigin.y; geoY < mapGeoBounds.getMaxY(); geoY += tileSizeInWorld.y) {
                --yIndex;
                imageHeight += tileSizeOnScreen.height;
                imageWidth = 0;
                int xIndex = -1;
                gridCoverageMaxX = gridCoverageOrigin.x;
                gridCoverageMaxY += tileSizeInWorld.y;
                for (double geoX = gridCoverageOrigin.x; geoX < mapGeoBounds.getMaxX(); geoX += tileSizeInWorld.x) {
                    ++xIndex;
                    imageWidth += tileSizeOnScreen.width;
                    gridCoverageMaxX += tileSizeInWorld.x;
                    ReferencedEnvelope tileBounds = new ReferencedEnvelope(geoX, geoX + tileSizeInWorld.x, geoY, geoY + tileSizeInWorld.y, mapProjection);
                    int row = (int)Math.round((tileCacheBounds.getMaxY() - tileBounds.getMaxY()) * rowFactor);
                    int column = (int)Math.round((tileBounds.getMinX() - tileCacheBounds.getMinX()) * columnFactor);
                    ClientHttpRequest tileRequest = this.tiledLayer.getTileRequest(this.httpRequestFactory, commonUrl, tileBounds, tileSizeOnScreen, column, row);
                    if (this.isInTileCacheBounds(tileCacheBounds, tileBounds)) {
                        if (!this.isTileVisible(tileBounds)) continue;
                        tileRequest = this.requestCache.register(tileRequest);
                        tiles.add(new TilePreparationInfo.SingleTilePreparationInfo(xIndex, yIndex, tileRequest));
                        continue;
                    }
                    LOGGER.debug("Tile out of bounds: {}", (Object)tileRequest);
                    tiles.add(new TilePreparationInfo.SingleTilePreparationInfo(xIndex, yIndex, null));
                }
            }
            return new TilePreparationInfo(tiles, imageWidth, imageHeight, gridCoverageOrigin, gridCoverageMaxX, gridCoverageMaxY, mapProjection);
        }
        catch (Exception e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    private boolean isInTileCacheBounds(ReferencedEnvelope tileCacheBounds, ReferencedEnvelope tilesBounds) {
        double boundsMinX = tilesBounds.getMinX();
        double boundsMinY = tilesBounds.getMinY();
        return boundsMinX >= tileCacheBounds.getMinX() && boundsMinX <= tileCacheBounds.getMaxX() && boundsMinY >= tileCacheBounds.getMinY() && boundsMinY <= tileCacheBounds.getMaxY();
    }

    private boolean isTileVisible(ReferencedEnvelope tileBounds) {
        if (FloatingPointUtil.equals(this.transformer.getRotation(), 0.0)) {
            return true;
        }
        GeometryFactory gfac = new GeometryFactory();
        Optional<Geometry> rotatedMapBounds = this.getRotatedMapBounds(gfac);
        if (rotatedMapBounds.isPresent()) {
            return ((Geometry)rotatedMapBounds.get()).intersects(gfac.toGeometry((Envelope)tileBounds));
        }
        return true;
    }

    private Optional<Geometry> getRotatedMapBounds(GeometryFactory gfac) {
        if (this.cachedRotatedMapBounds != null) {
            return this.cachedRotatedMapBounds;
        }
        ReferencedEnvelope mapBounds = this.transformer.getBounds().toReferencedEnvelope(new Rectangle(this.transformer.getMapSize()));
        Coordinate center = mapBounds.centre();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(this.transformer.getRotation(), center.x, center.y);
        AffineTransform2D mathTransform = new AffineTransform2D(affineTransform);
        try {
            Geometry rotatedBounds = JTS.transform((Geometry)gfac.toGeometry((Envelope)mapBounds), (MathTransform)mathTransform);
            this.cachedRotatedMapBounds = Optional.of((Object)rotatedBounds);
        }
        catch (TransformException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to rotate map bounds: " + mapBounds.toString(), (Throwable)e);
            }
            this.cachedRotatedMapBounds = Optional.absent();
        }
        return this.cachedRotatedMapBounds;
    }
}

