/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.google.common.collect.Maps;
import com.vividsolutions.jts.util.Assert;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.mapfish.print.ExtraPropertyException;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.HttpRequestHeadersAttribute;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.ConfigFileResolvingHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.mapfish.print.output.AttributeParsingException;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.mapfish.print.wrapper.ObjectMissingException;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;

public final class Values {
    public static final String TASK_DIRECTORY_KEY = "tempTaskDirectory";
    public static final String CLIENT_HTTP_REQUEST_FACTORY_KEY = "clientHttpRequestFactoryProvider";
    public static final String TEMPLATE_KEY = "template";
    public static final String PDF_CONFIG_KEY = "pdfConfig";
    public static final String OUTPUT_FORMAT_KEY = "outputFormat";
    public static final String SUBREPORT_DIR_KEY = "SUBREPORT_DIR";
    public static final String JOB_ID_KEY = "jobId";
    public static final String VALUES_KEY = "values";
    private final Map<String, Object> values = new ConcurrentHashMap<String, Object>();

    public Values(Map<String, Object> values) {
        this.values.putAll(values);
    }

    public Values() {
    }

    public Values(String jobId, PJsonObject requestData, Template template, File taskDirectory, MfClientHttpRequestFactoryImpl httpRequestFactory, File jasperTemplateBuild) throws JSONException {
        this(jobId, requestData, template, taskDirectory, httpRequestFactory, jasperTemplateBuild, null);
    }

    public Values(String jobId, PJsonObject requestData, Template template, File taskDirectory, MfClientHttpRequestFactoryImpl httpRequestFactory, File jasperTemplateBuild, String outputFormat) throws JSONException {
        Assert.isTrue((!taskDirectory.mkdirs() || taskDirectory.exists() ? 1 : 0) != 0);
        this.values.put(TASK_DIRECTORY_KEY, taskDirectory);
        this.values.put(CLIENT_HTTP_REQUEST_FACTORY_KEY, new MfClientHttpRequestFactoryProvider(new ConfigFileResolvingHttpRequestFactory(httpRequestFactory, template.getConfiguration(), jobId)));
        this.values.put(TEMPLATE_KEY, template);
        this.values.put(PDF_CONFIG_KEY, template.getPdfConfig());
        if (jasperTemplateBuild != null) {
            this.values.put(SUBREPORT_DIR_KEY, jasperTemplateBuild.getAbsolutePath());
        }
        if (outputFormat != null) {
            this.values.put(OUTPUT_FORMAT_KEY, outputFormat);
        }
        PJsonObject jsonAttributes = requestData.getJSONObject("attributes");
        HashMap attributes = Maps.newHashMap(template.getAttributes());
        this.populateFromAttributes(template, attributes, jsonAttributes);
        this.values.put(JOB_ID_KEY, jobId);
        this.values.put(VALUES_KEY, this);
    }

    public Values(@Nonnull Values values) {
        this.addRequiredValues(values);
    }

    public void populateFromAttributes(@Nonnull Template template, @Nonnull Map<String, Attribute> attributes, @Nonnull PObject requestJsonAttributes) throws JSONException {
        if (requestJsonAttributes.has("requestHeaders") && requestJsonAttributes.getObject("requestHeaders").has("requestHeaders") && !attributes.containsKey("requestHeaders")) {
            attributes.put("requestHeaders", new HttpRequestHeadersAttribute());
        }
        for (String attributeName : attributes.keySet()) {
            Attribute attribute = attributes.get(attributeName);
            try {
                this.put(attributeName, attribute.getValue(template, attributeName, requestJsonAttributes));
            }
            catch (IllegalArgumentException | ObjectMissingException e) {
                throw e;
            }
            catch (Throwable e) {
                String templateName = "unknown";
                for (Map.Entry<String, Template> entry : template.getConfiguration().getTemplates().entrySet()) {
                    if (entry.getValue() != template) continue;
                    templateName = entry.getKey();
                }
                String defaults = "";
                if (attribute instanceof ReflectiveAttribute) {
                    ReflectiveAttribute reflectiveAttribute = (ReflectiveAttribute)attribute;
                    defaults = "\n\n The attribute defaults are: " + reflectiveAttribute.getDefaultValue();
                }
                String errorMsg = "An error occurred when creating a value from the '" + attributeName + "' attribute for the '" + templateName + "' template.\n\nThe JSON is: \n" + requestJsonAttributes + defaults + "\n" + e.toString();
                throw new AttributeParsingException(errorMsg, e);
            }
        }
        if (template.getConfiguration().isThrowErrorOnExtraParameters()) {
            ArrayList<String> extraProperties = new ArrayList<String>();
            Iterator<String> it = requestJsonAttributes.keys();
            while (it.hasNext()) {
                String attributeName = it.next();
                if (attributes.containsKey(attributeName)) continue;
                extraProperties.add(attributeName);
            }
            if (!extraProperties.isEmpty()) {
                throw new ExtraPropertyException("Extra properties found in the request attributes", extraProperties, attributes.keySet());
            }
        }
    }

    public void addRequiredValues(@Nonnull Values sourceValues) {
        Object taskDirectory = sourceValues.getObject(TASK_DIRECTORY_KEY, Object.class);
        MfClientHttpRequestFactoryProvider requestFactoryProvider = sourceValues.getObject(CLIENT_HTTP_REQUEST_FACTORY_KEY, MfClientHttpRequestFactoryProvider.class);
        Template template = sourceValues.getObject(TEMPLATE_KEY, Template.class);
        PDFConfig pdfConfig = sourceValues.getObject(PDF_CONFIG_KEY, PDFConfig.class);
        String subReportDir = sourceValues.getString(SUBREPORT_DIR_KEY);
        this.values.put(TASK_DIRECTORY_KEY, taskDirectory);
        this.values.put(CLIENT_HTTP_REQUEST_FACTORY_KEY, requestFactoryProvider);
        this.values.put(TEMPLATE_KEY, template);
        this.values.put(PDF_CONFIG_KEY, pdfConfig);
        this.values.put(SUBREPORT_DIR_KEY, subReportDir);
        this.values.put(VALUES_KEY, this);
        this.values.put(JOB_ID_KEY, sourceValues.getString(JOB_ID_KEY));
    }

    public void put(String key, Object value) {
        if (TASK_DIRECTORY_KEY.equals(key) && this.values.keySet().contains(TASK_DIRECTORY_KEY)) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        if (value == null) {
            throw new IllegalArgumentException("A null value was attempted to be put into the values object under key: " + key);
        }
        this.values.put(key, value);
    }

    public Map<String, Object> asMap() {
        return this.values;
    }

    public String getString(String key) {
        return (String)this.values.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.values.get(key);
    }

    public Integer getInteger(String key) {
        return (Integer)this.values.get(key);
    }

    public <V> V getObject(String key, Class<V> type) {
        Object obj = this.values.get(key);
        return type.cast(obj);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    @Nullable
    public Boolean getBoolean(@Nonnull String key) {
        return (Boolean)this.values.get(key);
    }

    public void remove(String key) {
        this.values.remove(key);
    }

    public <T> Map<String, T> find(Class<T> valueTypeToFind) {
        Map filtered = Maps.filterEntries(this.values, input -> input != null && valueTypeToFind.isInstance(input.getValue()));
        return filtered;
    }

    public String toString() {
        HashMap<String, Object> display = new HashMap<String, Object>(this.values);
        display.remove(VALUES_KEY);
        return ((Object)display).toString();
    }
}

