/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.MapfishMapContext;

public class ExecutionStats {
    private List<MapStats> mapStats = new ArrayList<MapStats>();

    public synchronized void addMapStats(MapfishMapContext mapContext, MapAttribute.MapAttributeValues mapValues) {
        this.mapStats.add(new MapStats(mapContext, mapValues));
    }

    public ObjectNode toJson() {
        JsonNodeFactory nc = JsonNodeFactory.instance;
        ObjectNode stats = new ObjectNode(nc);
        ArrayNode maps = stats.putArray("maps");
        for (MapStats map : this.mapStats) {
            map.toJson(maps.addObject());
        }
        return stats;
    }

    private static final class MapStats {
        private final double dpi;
        private final Dimension size;
        private final int nbLayers;

        private MapStats(MapfishMapContext mapContext, MapAttribute.MapAttributeValues mapValues) {
            this.dpi = mapContext.getDPI();
            this.size = mapValues.getMapSize();
            this.nbLayers = mapValues.layers.size();
        }

        public void toJson(ObjectNode target) {
            target.put("dpi", this.dpi).put("nbLayers", this.nbLayers).putObject("size").put("width", this.size.width).put("height", this.size.height);
        }
    }
}

