/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorGraphNode;

public final class ProcessorExecutionContext {
    private final Values values;
    private final IdentityHashMap<Processor, Void> runningProcessors = new IdentityHashMap();
    private final IdentityHashMap<Processor, Void> executedProcessors = new IdentityHashMap();
    private final Lock processorLock = new ReentrantLock();
    private final AbstractProcessor.Context context;

    public ProcessorExecutionContext(Values values) {
        this.values = values;
        this.context = new AbstractProcessor.Context();
    }

    public Values getValues() {
        return this.values;
    }

    public boolean tryStart(ProcessorGraphNode processorGraphNode) {
        boolean canStart;
        this.processorLock.lock();
        try {
            if (this.isRunning(processorGraphNode) || this.isFinished(processorGraphNode) || !this.allAreFinished(processorGraphNode.getRequirements())) {
                canStart = false;
            } else {
                this.started(processorGraphNode);
                canStart = true;
            }
        }
        finally {
            this.processorLock.unlock();
        }
        return canStart;
    }

    private void started(ProcessorGraphNode processorGraphNode) {
        this.processorLock.lock();
        try {
            this.runningProcessors.put(processorGraphNode.getProcessor(), null);
        }
        finally {
            this.processorLock.unlock();
        }
    }

    public boolean isRunning(ProcessorGraphNode processorGraphNode) {
        this.processorLock.lock();
        try {
            boolean bl = this.runningProcessors.containsKey(processorGraphNode.getProcessor());
            return bl;
        }
        finally {
            this.processorLock.unlock();
        }
    }

    public boolean isFinished(ProcessorGraphNode processorGraphNode) {
        this.processorLock.lock();
        try {
            boolean bl = this.executedProcessors.containsKey(processorGraphNode.getProcessor());
            return bl;
        }
        finally {
            this.processorLock.unlock();
        }
    }

    public void finished(ProcessorGraphNode processorGraphNode) {
        this.processorLock.lock();
        try {
            this.runningProcessors.remove(processorGraphNode.getProcessor());
            this.executedProcessors.put(processorGraphNode.getProcessor(), null);
        }
        finally {
            this.processorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allAreFinished(Set<ProcessorGraphNode<?, ?>> processorNodes) {
        this.processorLock.lock();
        try {
            for (ProcessorGraphNode<?, ?> node : processorNodes) {
                if (this.isFinished(node)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.processorLock.unlock();
        }
    }

    public void cancel() {
        this.context.cancel();
    }

    public AbstractProcessor.Context getContext() {
        return this.context;
    }

    public String getJobId() {
        return this.values.getString("jobId");
    }
}

