/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import com.google.common.base.Optional;
import java.util.List;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.processor.http.matcher.HostMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostnameMatcher
extends HostMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostnameMatcher.class);
    private String host;

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.host == null) {
            validationErrors.add(new ConfigurationException("No host defined: " + this.getClass().getName()));
        }
    }

    @Override
    protected Optional<Boolean> tryOverrideValidation(MatchInfo matchInfo) {
        String host = matchInfo.getHost();
        if (host == MatchInfo.ANY_HOST) {
            return Optional.absent();
        }
        if (this.isHostnameMatch(host)) {
            return Optional.absent();
        }
        return Optional.of((Object)false);
    }

    protected boolean isHostnameMatch(String host) {
        boolean match = this.host.equalsIgnoreCase(host);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured hostname '" + this.host + "' matches requested '" + host + "': " + match);
        }
        return match;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HostnameMatcher");
        sb.append("{host='").append(this.host).append('\'');
        if (this.port >= 0) {
            sb.append(", port=").append(this.port);
        }
        if (this.pathRegex != null) {
            sb.append(", pathRegexp=").append(this.pathRegex);
        }
        sb.append(", reject=").append(this.isReject());
        sb.append('}');
        return sb.toString();
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostnameMatcher other = (HostnameMatcher)obj;
        return !(this.host == null ? other.host != null : !this.host.equals(other.host));
    }
}

