/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public abstract class BaseMapServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMapServlet.class);
    private int cacheDurationInSeconds = 3600;

    protected static String cleanUpName(String original) {
        return original.replace(",", "").replaceAll("\\s+", "_");
    }

    public static String findReplacement(String variableName, Date date) {
        if (variableName.equalsIgnoreCase("date")) {
            return BaseMapServlet.cleanUpName(DateFormat.getDateInstance().format(date));
        }
        if (variableName.equalsIgnoreCase("datetime")) {
            return BaseMapServlet.cleanUpName(DateFormat.getDateTimeInstance().format(date));
        }
        if (variableName.equalsIgnoreCase("time")) {
            return BaseMapServlet.cleanUpName(DateFormat.getTimeInstance().format(date));
        }
        try {
            return new SimpleDateFormat(variableName).format(date);
        }
        catch (Exception e) {
            LOGGER.error("Unable to format timestamp according to pattern: " + variableName, (Throwable)e);
            return "${" + variableName + "}";
        }
    }

    protected static final void error(HttpServletResponse httpServletResponse, String message, HttpStatus code) {
        try (PrintWriter out = null;){
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(code.value());
            out = httpServletResponse.getWriter();
            out.println("Error while processing request:");
            out.println(message);
            LOGGER.error("Error while processing request: " + message);
        }
    }

    protected final void error(HttpServletResponse httpServletResponse, Throwable e) {
        try (PrintWriter out = null;){
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            out = httpServletResponse.getWriter();
            out.println("Error while processing request:");
            LOGGER.error("Error while processing request", e);
        }
    }

    protected final StringBuilder getBaseUrl(HttpServletRequest httpServletRequest) {
        StringBuilder baseURL = new StringBuilder();
        if (httpServletRequest.getContextPath() != null && !httpServletRequest.getContextPath().isEmpty()) {
            baseURL.append(httpServletRequest.getContextPath());
        }
        if (httpServletRequest.getServletPath() != null && !httpServletRequest.getServletPath().isEmpty()) {
            baseURL.append(httpServletRequest.getServletPath());
        }
        return baseURL;
    }

    public final void setCacheDuration(int cacheDurationInSeconds) {
        this.cacheDurationInSeconds = cacheDurationInSeconds;
    }

    protected void setNoCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=0, must-revalidate, no-cache, no-store");
    }

    protected void setCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=" + String.valueOf(this.cacheDurationInSeconds));
    }
}

