/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class RequestSizeFilter
implements Filter {
    private static final int MAX_CONTENT_LENGTH = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestSizeFilter.class);
    private int maxContentLength = 0x100000;

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getContentLength() > this.maxContentLength) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            LOGGER.error("Request size exceeds limit: " + request.getContentLength() + " bytes");
            httpResponse.sendError(HttpStatus.BAD_REQUEST.value(), "Request size exceeds limit");
        } else {
            chain.doFilter(request, response);
        }
    }

    public final void init(FilterConfig config) {
        if (System.getProperty("mapfish.maxContentLength") != null) {
            this.maxContentLength = Integer.parseInt(System.getProperty("mapfish.maxContentLength"));
        } else if (config.getInitParameter("maxContentLength") != null) {
            this.maxContentLength = Integer.parseInt(config.getInitParameter("maxContentLength"));
        }
    }

    public void destroy() {
    }
}

