/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.fileloader;

import com.google.common.base.Optional;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mapfish.print.FileUtils;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderPlugin;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFileConfigFileLoader
implements ConfigFileLoaderPlugin {
    @Autowired
    private WorkingDirectories workingDirectories;

    protected static File platformIndependentUriToFile(URI fileURI) {
        File file;
        try {
            file = new File(fileURI);
        }
        catch (IllegalArgumentException e) {
            if (fileURI.toString().startsWith("file://")) {
                file = new File(fileURI.toString().substring("file://".length()));
            }
            throw e;
        }
        return file;
    }

    protected abstract Iterator<File> resolveFiles(URI var1);

    @Override
    public final Optional<File> toFile(URI fileUri) {
        try {
            Iterator<File> fileIterator = this.resolveFiles(fileUri);
            while (fileIterator.hasNext()) {
                File next = fileIterator.next();
                if (!next.exists()) continue;
                return Optional.of((Object)next);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.absent();
    }

    @Override
    public final Optional<Long> lastModified(URI fileURI) {
        Optional<File> file = this.findFile(this.resolveFiles(fileURI));
        if (file.isPresent()) {
            return Optional.of((Object)((File)file.get()).lastModified());
        }
        throw new NoSuchElementException("No config file found at: " + fileURI);
    }

    @Override
    public final boolean isAccessible(URI fileURI) {
        if (!fileURI.getScheme().equalsIgnoreCase(this.getUriScheme())) {
            return false;
        }
        Optional<File> file = this.findFile(this.resolveFiles(fileURI));
        if (file.isPresent() && ((File)file.get()).isDirectory()) {
            throw new IllegalArgumentException(fileURI + " does not refer to a file, it is a directory");
        }
        return file.isPresent() && ((File)file.get()).exists();
    }

    @Override
    public final byte[] loadFile(URI fileURI) throws IOException {
        Optional<File> file = this.findFile(this.resolveFiles(fileURI));
        if (file.isPresent() && ((File)file.get()).exists()) {
            return Files.toByteArray((File)((File)file.get()));
        }
        throw new NoSuchElementException("No config file found at: " + fileURI);
    }

    @Override
    public final boolean isAccessible(URI configFileUri, String pathToSubResource) throws IOException {
        try {
            Optional<File> childFile = this.resolveChildFile(configFileUri, pathToSubResource);
            return childFile.isPresent() && ((File)childFile.get()).exists();
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public final byte[] loadFile(URI configFileUri, String pathToSubResource) throws IOException {
        Optional<File> childFile = this.resolveChildFile(configFileUri, pathToSubResource);
        if (childFile.isPresent() && ((File)childFile.get()).exists()) {
            return Files.toByteArray((File)((File)childFile.get()));
        }
        throw new NoSuchElementException("File does not exist: " + childFile);
    }

    private Optional<File> findFile(Iterator<File> files) {
        while (files.hasNext()) {
            File next = files.next();
            if (!next.isFile()) continue;
            return Optional.of((Object)next);
        }
        return Optional.absent();
    }

    private Optional<File> resolveChildFile(URI configFileUri, String pathToSubResource) throws IOException {
        Optional<File> configFileOptional = this.findFile(this.resolveFiles(configFileUri));
        if (!configFileOptional.isPresent()) {
            throw new NoSuchElementException("No configuration file found at: " + configFileUri);
        }
        File configFile = (File)configFileOptional.get();
        try {
            URI uri = new URI(pathToSubResource);
            File configDir = configFile.getParentFile();
            if (pathToSubResource.startsWith(this.getUriScheme())) {
                Iterator<File> fileIterator = this.resolveFiles(uri);
                while (fileIterator.hasNext()) {
                    File next = fileIterator.next();
                    if (!next.exists()) continue;
                    FileUtils.assertIsSubDirectory("configuration", next, configDir, this.workingDirectories.getWorking());
                    return Optional.of((Object)next);
                }
                File childFile = new File(configDir, AbstractFileConfigFileLoader.platformIndependentUriToFile(uri).getPath());
                if (childFile.exists()) {
                    FileUtils.assertIsSubDirectory("configuration", childFile, configDir, this.workingDirectories.getWorking());
                    return Optional.of((Object)childFile);
                }
            }
            try {
                File childFile = AbstractFileConfigFileLoader.platformIndependentUriToFile(uri);
                if (childFile.exists()) {
                    FileUtils.assertIsSubDirectory("configuration", childFile, configDir, this.workingDirectories.getWorking());
                    return Optional.of((Object)childFile);
                }
                return Optional.absent();
            }
            catch (IllegalArgumentException e) {
                return this.resolveFileAssumingPathIsFile(pathToSubResource, configFile);
            }
        }
        catch (URISyntaxException e) {
            return this.resolveFileAssumingPathIsFile(pathToSubResource, configFile);
        }
    }

    private Optional<File> resolveFileAssumingPathIsFile(String pathToSubResource, File configFile) {
        File childFile = new File(configFile.getParentFile(), pathToSubResource);
        if (childFile.exists()) {
            return Optional.of((Object)childFile);
        }
        childFile = new File(pathToSubResource);
        if (childFile.exists()) {
            FileUtils.assertIsSubDirectory("configuration", childFile, configFile.getParentFile(), this.workingDirectories.getWorking());
            return Optional.of((Object)childFile);
        }
        return Optional.absent();
    }
}

