/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.cli;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.sampullara.cli.Args;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.json.JSONWriter;
import org.mapfish.print.Constants;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.cli.CliDefinition;
import org.mapfish.print.cli.CliHelpDefinition;
import org.mapfish.print.servlet.oldapi.OldAPIRequestConverter;
import org.mapfish.print.url.data.Handler;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class Main {
    public static final String DEFAULT_SPRING_CONTEXT = "/mapfish-cli-spring-application-context.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final int LOGLEVEL_QUIET = 0;
    private static final int LOGLEVEL_INFO = 1;
    private static final int LOGLEVEL_DEFAULT = 2;
    private static final int LOGLEVEL_VERBOSE = 3;
    private static boolean exceptionOnFailure;
    @Autowired
    private MapPrinter mapPrinter;

    private Main() {
    }

    public static void main(String[] args) throws Exception {
        Main.runMain(args);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void runMain(String[] args) throws Exception {
        CliHelpDefinition helpCli = new CliHelpDefinition();
        try {
            Args.parse((Object)helpCli, (String[])args);
            if (helpCli.help) {
                Main.printUsage(0);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CliDefinition cli = new CliDefinition();
        try {
            List unusedArguments = Args.parse((Object)cli, (String[])args);
            if (!unusedArguments.isEmpty()) {
                System.out.println("\n\nThe following arguments are not recognized: " + unusedArguments);
                Main.printUsage(1);
                return;
            }
        }
        catch (IllegalArgumentException invalidOption) {
            System.out.println("\n\n" + invalidOption.getMessage());
            Main.printUsage(1);
            return;
        }
        Main.configureLogs(cli.verbose);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(DEFAULT_SPRING_CONTEXT);
        if (cli.springConfig != null) {
            context = new ClassPathXmlApplicationContext(new String[]{DEFAULT_SPRING_CONTEXT, cli.springConfig});
        }
        try {
            ((Main)context.getBean(Main.class)).run(cli);
        }
        finally {
            context.destroy();
        }
    }

    private static void printUsage(int exitCode) {
        Args.usage((Object)new CliDefinition());
        if (exceptionOnFailure) {
            throw new Error("Printing Usage: " + exitCode);
        }
        System.exit(exitCode);
    }

    private static void configureLogs(String verbose) {
        URL logfile;
        ClassLoader classLoader = Main.class.getClassLoader();
        switch (Integer.parseInt(verbose)) {
            case 0: {
                logfile = classLoader.getResource("shell-quiet-log.xml");
                break;
            }
            case 1: {
                logfile = classLoader.getResource("shell-info-log.xml");
                break;
            }
            case 2: {
                logfile = classLoader.getResource("shell-default-log.xml");
                break;
            }
            case 3: {
                logfile = classLoader.getResource("shell-verbose-log.xml");
                break;
            }
            default: {
                logfile = classLoader.getResource("shell-default-log.xml");
            }
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            loggerContext.reset();
            configurator.doConfigure(logfile);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
    }

    @VisibleForTesting
    static void setExceptionOnFailure(boolean exceptionOnFailure) {
        Main.exceptionOnFailure = exceptionOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(CliDefinition cli) throws Exception {
        File configFile = new File(cli.config);
        this.mapPrinter.setConfiguration(configFile);
        try (OutputStream outFile = null;){
            if (cli.clientConfig) {
                outFile = this.getOutputStream(cli.output, ".yaml");
                OutputStreamWriter writer = new OutputStreamWriter(outFile, Charset.forName(Constants.DEFAULT_ENCODING));
                JSONWriter json = new JSONWriter((Appendable)writer);
                json.object();
                this.mapPrinter.printClientConfig(json);
                json.endObject();
                writer.close();
            } else {
                InputStream inFile = this.getInputStream(cli.spec);
                String jsonConfiguration = CharStreams.toString((Readable)new InputStreamReader(inFile, Constants.DEFAULT_ENCODING));
                PJsonObject jsonSpec = MapPrinter.parseSpec(jsonConfiguration);
                if (cli.v2Api) {
                    PJsonObject oldApiSpec = jsonSpec;
                    LOGGER.info("Converting request data from V2 API request data to V3 API");
                    jsonSpec = OldAPIRequestConverter.convert(oldApiSpec, this.mapPrinter.getConfiguration());
                }
                outFile = this.getOutputStream(cli.output, this.mapPrinter.getOutputFormat(jsonSpec).getFileSuffix());
                LOGGER.debug("Request Data: \n" + jsonSpec.getInternalObj().toString(2));
                this.mapPrinter.print("main", jsonSpec, outFile);
            }
        }
    }

    private OutputStream getOutputStream(String output, String suffix) throws FileNotFoundException {
        OutputStream outFile;
        String outputPath = output;
        if (outputPath != null) {
            if (!outputPath.endsWith("." + suffix)) {
                outputPath = outputPath + "." + suffix;
            }
            outFile = new FileOutputStream(outputPath);
        } else {
            outFile = System.out;
        }
        return outFile;
    }

    private InputStream getInputStream(String spec) throws FileNotFoundException {
        InputStream file = spec != null ? new FileInputStream(spec) : System.in;
        return file;
    }

    static {
        Handler.configureProtocolHandler();
    }
}

