/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.output.AbstractJasperReportOutputFormat;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.processor.ExecutionStats;

public final class JasperReportPDFOutputFormat
extends AbstractJasperReportOutputFormat
implements OutputFormat {
    @Override
    public String getContentType() {
        return "application/pdf";
    }

    @Override
    public String getFileSuffix() {
        return "pdf";
    }

    @Override
    protected void doExport(OutputStream outputStream, AbstractJasperReportOutputFormat.Print print) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter(print.context);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(print.print));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
        SimplePdfExporterConfiguration configuration = new SimplePdfExporterConfiguration();
        configuration.setPdfVersion(PdfVersionEnum.VERSION_1_7);
        PDFConfig pdfConfig = print.values.getObject("pdfConfig", PDFConfig.class);
        configuration.setCompressed(Boolean.valueOf(pdfConfig.isCompressed()));
        configuration.setMetadataAuthor(pdfConfig.getAuthor());
        configuration.setMetadataCreator(pdfConfig.getCreator());
        configuration.setMetadataSubject(pdfConfig.getSubject());
        configuration.setMetadataTitle(pdfConfig.getTitle());
        configuration.setMetadataKeywords(pdfConfig.getKeywordsAsString());
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.exportReport();
        JasperPrint jasperPrint = exporter.getCurrentJasperPrint();
        ExecutionStats stats = print.executionContext.getStats();
        for (int i = 0; i < jasperPrint.getPages().size(); ++i) {
            PrintPageFormat pageFormat = jasperPrint.getPageFormat(i);
            stats.addPageStats(pageFormat);
        }
    }
}

