/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorUtils;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.mapfish.print.processor.http.HttpProcessor;

public final class CompositeClientHttpRequestFactoryProcessor
extends AbstractProcessor<Input, Void>
implements HttpProcessor<Input> {
    private List<HttpProcessor> httpProcessors = Lists.newArrayList();

    protected CompositeClientHttpRequestFactoryProcessor() {
        super(Void.class);
    }

    public void setHttpProcessors(List<HttpProcessor> httpProcessors) {
        this.httpProcessors = httpProcessors;
    }

    @Override
    public MfClientHttpRequestFactory createFactoryWrapper(Input input, MfClientHttpRequestFactory requestFactory) {
        MfClientHttpRequestFactory finalRequestFactory = requestFactory;
        for (int i = this.httpProcessors.size() - 1; i > -1; --i) {
            HttpProcessor processor = this.httpProcessors.get(i);
            Object populatedInput = ProcessorUtils.populateInputParameter(processor, input.values);
            finalRequestFactory = processor.createFactoryWrapper(populatedInput, finalRequestFactory);
        }
        return finalRequestFactory;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.httpProcessors.isEmpty()) {
            validationErrors.add(new IllegalStateException("There are no composite elements for this processor"));
        } else {
            for (HttpProcessor part : this.httpProcessors) {
                if (part instanceof HttpProcessor) continue;
                validationErrors.add(new IllegalStateException("One of the parts of " + this.getClass().getSimpleName() + " is not a " + HttpProcessor.class.getSimpleName()));
            }
        }
    }

    @Override
    @Nullable
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    @Nullable
    public Void execute(Input values, Processor.ExecutionContext context) {
        values.clientHttpRequestFactoryProvider.set(this.createFactoryWrapper(values, values.clientHttpRequestFactoryProvider.get()));
        return null;
    }

    @Override
    public void toString(StringBuilder builder, int indent, String parent) {
        super.toString(builder, indent, parent);
        for (HttpProcessor sub : this.httpProcessors) {
            sub.toString(builder, indent + 1, this.toString());
        }
    }

    public class Input
    extends ClientHttpFactoryProcessorParam {
        public Values values;
    }
}

