/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.styling.Style;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayerPlugin;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.StyleSupplier;

public final class FeatureLayer
extends AbstractFeatureSourceLayer {
    public FeatureLayer(ExecutorService executorService, FeatureSourceSupplier featureSourceSupplier, StyleSupplier<FeatureSource> styleSupplier, boolean renderAsSvg, AbstractLayerParams params) {
        super(executorService, featureSourceSupplier, styleSupplier, renderAsSvg, params);
    }

    public static class FeatureLayerParam
    extends AbstractLayerParams {
        public SimpleFeatureCollection features;
        public String style;
        public String defaultStyle;
        public Boolean renderAsSvg;
    }

    public static final class Plugin
    extends AbstractFeatureSourceLayerPlugin<FeatureLayerParam> {
        private static final String TYPE = "feature";

        public Plugin() {
            super(TYPE, new String[0]);
        }

        @Override
        public FeatureLayerParam createParameter() {
            return new FeatureLayerParam();
        }

        @Nonnull
        public FeatureLayer parse(@Nonnull Template template, @Nonnull FeatureLayerParam param) {
            return new FeatureLayer(this.forkJoinPool, this.createFeatureSourceSupplier(param.features), this.createStyleFunction(template, param.style, param.defaultStyle), template.getConfiguration().renderAsSvg(param.renderAsSvg), param);
        }

        private FeatureSourceSupplier createFeatureSourceSupplier(final SimpleFeatureCollection features) {
            return new FeatureSourceSupplier(){

                @Override
                public FeatureSource load(MfClientHttpRequestFactory requestFactory, MapfishMapContext mapContext) {
                    return new CollectionFeatureSource(features);
                }
            };
        }

        protected StyleSupplier<FeatureSource> createStyleFunction(final Template template, final String styleString, final String defaultStyleName) {
            return new StyleSupplier<FeatureSource>(){

                @Override
                public Style load(MfClientHttpRequestFactory requestFactory, FeatureSource featureSource) {
                    if (featureSource == null) {
                        throw new IllegalArgumentException("Feature source cannot be null");
                    }
                    String geomType = featureSource.getSchema().getGeometryDescriptor().getType().getBinding().getSimpleName();
                    String styleRef = styleString;
                    if (styleRef == null) {
                        styleRef = defaultStyleName != null ? defaultStyleName : geomType;
                    }
                    return (Style)template.getStyle(styleRef).or(parser.loadStyle(template.getConfiguration(), requestFactory, styleRef)).or((Object)template.getConfiguration().getDefaultStyle(styleRef));
                }
            };
        }
    }
}

