/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.FileRepositoryService;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

class MapfishPrintRepositoryService
implements StreamRepositoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapfishPrintRepositoryService.class);
    private final MfClientHttpRequestFactory httpRequestFactory;
    private JasperReportsContext jasperReportsContext;

    MapfishPrintRepositoryService(@Nonnull MfClientHttpRequestFactory httpRequestFactory) {
        this.httpRequestFactory = httpRequestFactory;
        this.jasperReportsContext = DefaultJasperReportsContext.getInstance();
    }

    public InputStream getInputStream(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            uri = new File(uriString).toURI();
        }
        try {
            ClientHttpResponse response = this.httpRequestFactory.createRequest(uri, HttpMethod.GET).execute();
            return new ResponseClosingStream(response);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Resource getResource(String uri) {
        throw new UnsupportedOperationException();
    }

    public void saveResource(String uri, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        try {
            InputStream inputStream;
            if (resourceType.isAssignableFrom(InputStreamResource.class) && (inputStream = this.getInputStream(uri)) != null) {
                InputStreamResource resource = new InputStreamResource();
                resource.setInputStream(inputStream);
                return (K)((Resource)resourceType.cast(resource));
            }
            PersistenceUtil persistenceUtil = PersistenceUtil.getInstance((JasperReportsContext)this.jasperReportsContext);
            PersistenceService persistenceService = persistenceUtil.getService(FileRepositoryService.class, resourceType);
            if (persistenceService != null) {
                return (K)((Resource)resourceType.cast(persistenceService.load(uri, (RepositoryService)this)));
            }
        }
        catch (IllegalStateException e) {
            LOGGER.info("Resource not found {} ({}).", (Object)uri, (Object)e.toString());
        }
        catch (Exception e) {
            LOGGER.trace(String.format("Error on getting resource %s.", uri), (Throwable)e);
        }
        return null;
    }

    public OutputStream getOutputStream(String uri) {
        throw new UnsupportedOperationException();
    }

    private static final class ResponseClosingStream
    extends InputStream {
        private final Closer closer = Closer.create();
        private final InputStream stream;

        private ResponseClosingStream(ClientHttpResponse response) throws IOException {
            this.closer.register((Closeable)response);
            this.stream = (InputStream)this.closer.register((Closeable)response.getBody());
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
            super.close();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

