/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import java.util.List;
import org.geotools.styling.Style;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.StyleAttribute;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InputOutputValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class SetStyleProcessor
extends AbstractProcessor<Input, Void> {
    @Autowired
    private StyleParserPlugin mapfishJsonParser;

    protected SetStyleProcessor() {
        super(Void.class);
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Void execute(Input values, Processor.ExecutionContext context) {
        try {
            final Style style = (Style)this.mapfishJsonParser.parseStyle(values.template.getConfiguration(), values.clientHttpRequestFactoryProvider.get(), values.style.style).get();
            for (MapLayer layer : values.map.getLayers()) {
                this.checkCancelState(context);
                if (!(layer instanceof AbstractFeatureSourceLayer)) continue;
                ((AbstractFeatureSourceLayer)layer).setStyle(new StyleSupplier(){

                    public Style load(MfClientHttpRequestFactory requestFactory, Object featureSource) {
                        return style;
                    }
                });
            }
            return null;
        }
        catch (Throwable e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    public static final class Input {
        public MfClientHttpRequestFactoryProvider clientHttpRequestFactoryProvider;
        public Template template;
        @InputOutputValue
        public GenericMapAttribute.GenericMapAttributeValues map;
        public StyleAttribute.StylesAttributeValues style;
    }
}

