/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.base.Optional;
import java.awt.Graphics2D;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestFetcher;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.Processor;

public interface MapLayer {
    public Optional<MapLayer> tryAddLayer(MapLayer var1);

    public double getImageBufferScaling();

    public void prepareRender(MapfishMapContext var1);

    public void render(Graphics2D var1, MfClientHttpRequestFactory var2, MapfishMapContext var3, Processor.ExecutionContext var4);

    public boolean supportsNativeRotation();

    public String getName();

    public RenderType getRenderType();

    public void prefetchResources(HttpRequestFetcher var1, MfClientHttpRequestFactory var2, MapfishMapContext var3, Processor.ExecutionContext var4);

    public double getOpacity();

    public static enum RenderType {
        UNKNOWN,
        PNG,
        JPEG,
        TIFF,
        SVG;


        public static RenderType fromMimeType(String mimeType) {
            if (mimeType.equals("image/jpeg")) {
                return JPEG;
            }
            if (mimeType.equals("image/png")) {
                return PNG;
            }
            if (mimeType.matches("image/tiff(-fx)?")) {
                return TIFF;
            }
            if (mimeType.matches("image/svg(\\+xml)?")) {
                return SVG;
            }
            return UNKNOWN;
        }

        public static RenderType fromFileExtension(String fileExtension) {
            String extensionOrMimeLC = fileExtension.toLowerCase();
            if (extensionOrMimeLC.matches("jpe?g")) {
                return JPEG;
            }
            if (extensionOrMimeLC.equals("png")) {
                return PNG;
            }
            if (extensionOrMimeLC.matches("tiff?")) {
                return TIFF;
            }
            if (extensionOrMimeLC.equals("svg")) {
                return SVG;
            }
            return UNKNOWN;
        }
    }
}

