/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.mapfish.print.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public final class HttpRequestFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestFetcher.class);
    private final File temporaryDirectory;
    private final MetricRegistry registry;
    private final Processor.ExecutionContext context;
    private final ForkJoinPool requestForkJoinPool;

    public HttpRequestFetcher(File temporaryDirectory, MetricRegistry registry, Processor.ExecutionContext context, ForkJoinPool requestForkJoinPool) {
        this.temporaryDirectory = temporaryDirectory;
        this.registry = registry;
        this.context = context;
        this.requestForkJoinPool = requestForkJoinPool;
    }

    private CachedClientHttpRequest add(CachedClientHttpRequest request) {
        Future future = this.requestForkJoinPool.submit((Callable)request);
        request.setFuture((ForkJoinTask<Void>)future);
        return request;
    }

    public ClientHttpRequest register(ClientHttpRequest originalRequest) {
        return this.add(new CachedClientHttpRequest(originalRequest, this.context));
    }

    private final class CachedClientHttpRequest
    implements ClientHttpRequest,
    Callable<Void> {
        private final ClientHttpRequest originalRequest;
        private final Processor.ExecutionContext context;
        @Nullable
        private ClientHttpResponse response;
        @Nullable
        private ForkJoinTask<Void> future;

        private CachedClientHttpRequest(ClientHttpRequest request, Processor.ExecutionContext context) {
            this.originalRequest = request;
            this.context = context;
        }

        public HttpMethod getMethod() {
            return this.originalRequest.getMethod();
        }

        public String getMethodValue() {
            HttpMethod method = this.originalRequest.getMethod();
            return method != null ? method.name() : "";
        }

        public URI getURI() {
            return this.originalRequest.getURI();
        }

        public HttpHeaders getHeaders() {
            return this.originalRequest.getHeaders();
        }

        public OutputStream getBody() {
            throw new UnsupportedOperationException();
        }

        public ClientHttpResponse execute() {
            assert (this.future != null);
            Timer.Context timerWait = HttpRequestFetcher.this.registry.timer(HttpRequestFetcher.class.getName() + ".waitDownloader").time();
            this.future.join();
            timerWait.stop();
            assert (this.response != null);
            LOGGER.debug("Loading cached URI resource {}", (Object)this.originalRequest.getURI());
            ClientHttpResponse result = this.response;
            this.response = null;
            this.future = null;
            return result;
        }

        @Override
        public Void call() throws Exception {
            return this.context.mdcContextEx(() -> {
                String baseMetricName = HttpRequestFetcher.class.getName() + ".read." + this.getURI().getHost();
                Timer.Context timerDownload = HttpRequestFetcher.this.registry.timer(baseMetricName).time();
                ClientHttpResponse originalResponse = null;
                try {
                    originalResponse = this.originalRequest.execute();
                    LOGGER.debug("Caching URI resource {}", (Object)this.originalRequest.getURI());
                    this.response = new CachedClientHttpResponse(originalResponse);
                }
                catch (IOException e) {
                    LOGGER.error("Request failed {}", (Object)this.originalRequest.getURI(), (Object)e);
                    this.response = new AbstractClientHttpResponse(){

                        public HttpHeaders getHeaders() {
                            return new HttpHeaders();
                        }

                        public InputStream getBody() {
                            return StreamUtils.emptyInput();
                        }

                        public int getRawStatusCode() {
                            return 500;
                        }

                        public String getStatusText() {
                            return e.getMessage();
                        }

                        public void close() {
                        }
                    };
                    HttpRequestFetcher.this.registry.counter(baseMetricName + ".error").inc();
                    throw e;
                }
                finally {
                    if (originalResponse != null) {
                        originalResponse.close();
                    }
                    timerDownload.stop();
                }
                return null;
            });
        }

        public void setFuture(ForkJoinTask<Void> future) {
            this.future = future;
        }
    }

    private final class CachedClientHttpResponse
    extends AbstractClientHttpResponse {
        private final File cachedFile;
        private final HttpHeaders headers;
        private final int status;
        private final String statusText;
        private InputStream body;

        private CachedClientHttpResponse(ClientHttpResponse originalResponse) throws IOException {
            this.headers = originalResponse.getHeaders();
            this.status = originalResponse.getRawStatusCode();
            this.statusText = originalResponse.getStatusText();
            this.cachedFile = File.createTempFile("cacheduri", null, HttpRequestFetcher.this.temporaryDirectory);
            try (InputStream is = originalResponse.getBody();
                 FileOutputStream os = new FileOutputStream(this.cachedFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
        }

        public InputStream getBody() throws IOException {
            if (this.body == null) {
                this.body = new FileInputStream(this.cachedFile);
            }
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public int getRawStatusCode() {
            return this.status;
        }

        public String getStatusText() {
            return this.statusText;
        }

        public void close() {
            if (this.body != null) {
                try {
                    this.body.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

