/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.protocol.HttpContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.ConfigurableRequest;
import org.mapfish.print.http.MfCredentialsProvider;
import org.mapfish.print.http.MfRoutePlanner;
import org.mapfish.print.http.MfSSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class MfClientHttpRequestFactoryImpl
extends HttpComponentsClientHttpRequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MfClientHttpRequestFactoryImpl.class);
    private static final ThreadLocal<Configuration> CURRENT_CONFIGURATION = new InheritableThreadLocal<Configuration>();

    public MfClientHttpRequestFactoryImpl(int maxConnTotal, int maxConnPerRoute) {
        super((HttpClient)MfClientHttpRequestFactoryImpl.createHttpClient(maxConnTotal, maxConnPerRoute));
    }

    @Nullable
    static Configuration getCurrentConfiguration() {
        return CURRENT_CONFIGURATION.get();
    }

    private static CloseableHttpClient createHttpClient(int maxConnTotal, int maxConnPerRoute) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableCookieManagement().setDnsResolver((DnsResolver)new RandomizingDnsResolver()).setRoutePlanner((HttpRoutePlanner)new MfRoutePlanner()).setSSLSocketFactory((LayeredConnectionSocketFactory)new MfSSLSocketFactory()).setDefaultCredentialsProvider((CredentialsProvider)new MfCredentialsProvider()).setMaxConnTotal(maxConnTotal).setMaxConnPerRoute(maxConnPerRoute);
        return httpClientBuilder.build();
    }

    public ConfigurableRequest createRequest(@Nonnull URI uri, @Nonnull HttpMethod httpMethod) throws IOException {
        HttpRequestBase httpRequest = (HttpRequestBase)this.createHttpUriRequest(httpMethod, uri);
        return new Request(this.getHttpClient(), httpRequest, this.createHttpContext(httpMethod, uri));
    }

    static class Response
    extends AbstractClientHttpResponse {
        private static final Logger LOGGER = LoggerFactory.getLogger(Response.class);
        private static final AtomicInteger ID_COUNTER = new AtomicInteger();
        private final HttpResponse response;
        private final int id = ID_COUNTER.incrementAndGet();
        private Closer closer = Closer.create();
        private InputStream inputStream;

        Response(@Nonnull HttpResponse response) {
            this.response = response;
            LOGGER.trace("Creating Http Response object: {}", (Object)this.id);
        }

        public int getRawStatusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getStatusText() {
            return this.response.getStatusLine().getReasonPhrase();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.close();
        }

        public void close() {
            try {
                this.getBody();
            }
            catch (IOException e) {
                LOGGER.error("Error occurred while trying to retrieve Http Response {} in order to close it.", (Object)this.id, (Object)e);
            }
            finally {
                try {
                    this.closer.close();
                }
                catch (IOException e) {
                    LOGGER.trace("Error while closing Http Response object: {}", (Object)this.id);
                    throw new RuntimeException(e);
                }
                LOGGER.trace("Closed Http Response object: {}", (Object)this.id);
            }
        }

        public synchronized InputStream getBody() throws IOException {
            if (this.inputStream == null) {
                HttpEntity entity = this.response.getEntity();
                if (entity != null) {
                    this.inputStream = (InputStream)this.closer.register((Closeable)entity.getContent());
                }
                if (this.inputStream == null) {
                    this.inputStream = new ByteArrayInputStream(new byte[0]);
                }
            }
            return this.inputStream;
        }

        public HttpHeaders getHeaders() {
            Header[] allHeaders;
            HttpHeaders translatedHeaders = new HttpHeaders();
            for (Header header : allHeaders = this.response.getAllHeaders()) {
                for (HeaderElement element : header.getElements()) {
                    translatedHeaders.add(header.getName(), element.toString());
                }
            }
            return translatedHeaders;
        }
    }

    public static final class Request
    extends AbstractClientHttpRequest
    implements ConfigurableRequest {
        private final HttpClient client;
        private final HttpRequestBase request;
        private final HttpContext context;
        private final ByteArrayOutputStream outputStream;
        private Configuration configuration;

        Request(@Nonnull HttpClient client, @Nonnull HttpRequestBase request, @Nullable HttpContext context) {
            this.client = client;
            this.request = request;
            this.context = context;
            this.outputStream = new ByteArrayOutputStream();
        }

        @Override
        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public HttpClient getClient() {
            return this.client;
        }

        public HttpContext getContext() {
            return this.context;
        }

        @Override
        public HttpRequestBase getUnderlyingRequest() {
            return this.request;
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.request.getMethod());
        }

        public String getMethodValue() {
            return this.request.getMethod();
        }

        public URI getURI() {
            return this.request.getURI();
        }

        protected OutputStream getBodyInternal(@Nonnull HttpHeaders headers) {
            return this.outputStream;
        }

        protected Response executeInternal(@Nonnull HttpHeaders headers) throws IOException {
            CURRENT_CONFIGURATION.set(this.configuration);
            LOGGER.debug("Preparing request {} -- {}", (Object)this.getMethod(), (Object)this.getURI());
            for (Map.Entry entry : headers.entrySet()) {
                String headerName = (String)entry.getKey();
                if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Transfer-Encoding")) continue;
                for (String headerValue : (List)entry.getValue()) {
                    LOGGER.debug("Setting header: {} : {}", (Object)headerName, (Object)headerValue);
                    this.request.addHeader(headerName, headerValue);
                }
            }
            if (this.request instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.request;
                ByteArrayEntity requestEntity = new ByteArrayEntity(this.outputStream.toByteArray());
                entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
            }
            HttpResponse response = this.client.execute((HttpUriRequest)this.request, this.context);
            LOGGER.debug("Response: {} -- {}", (Object)response.getStatusLine().getStatusCode(), (Object)this.getURI());
            return new Response(response);
        }
    }

    private static final class RandomizingDnsResolver
    extends SystemDefaultDnsResolver {
        private RandomizingDnsResolver() {
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            List<InetAddress> list = Arrays.asList(super.resolve(host));
            Collections.shuffle(list);
            return list.toArray(new InetAddress[list.size()]);
        }
    }
}

