/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.vividsolutions.jts.util.Assert;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.mapfish.print.map.image.wms.WmsVersion;
import org.mapfish.print.map.tiled.AbstractWMXLayerParams;
import org.mapfish.print.parser.HasDefaultValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class WmsLayerParam
extends AbstractWMXLayerParams {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmsLayerParam.class);
    public String baseURL;
    public String[] layers;
    @HasDefaultValue
    public String[] styles;
    @HasDefaultValue
    public String version = "1.1.1";
    @HasDefaultValue
    public boolean useNativeAngle = true;
    @HasDefaultValue
    public ServerType serverType;
    @HasDefaultValue
    public String imageFormat = "image/png";
    @HasDefaultValue
    public HttpMethod method = HttpMethod.GET;

    public WmsLayerParam() {
    }

    public WmsLayerParam(WmsLayerParam other) {
        super(other);
        this.baseURL = other.baseURL;
        this.layers = other.layers;
        this.styles = other.styles;
        this.version = other.version;
        this.useNativeAngle = other.useNativeAngle;
        this.serverType = other.serverType;
        this.imageFormat = other.imageFormat;
        this.method = other.method;
    }

    @Override
    public final String getBaseUrl() {
        return this.baseURL;
    }

    public void postConstruct() throws URISyntaxException {
        WmsVersion.lookup(this.version);
        Assert.isTrue((boolean)this.validateBaseUrl(), (String)"invalid baseURL");
        Assert.isTrue((this.layers.length > 0 ? 1 : 0) != 0, (String)"There must be at least one layer defined for a WMS request to make sense");
        if (this.styles != null && this.styles.length != this.layers.length && this.styles.length == 1 && this.styles[0].trim().isEmpty()) {
            this.styles = null;
        } else {
            Assert.isTrue((this.styles == null || this.layers.length == this.styles.length ? 1 : 0) != 0, (String)String.format("If styles are defined then there must be one for each layer.  Number of layers: %s\nStyles: %s", this.layers.length, Arrays.toString(this.styles)));
        }
        if (this.imageFormat.indexOf(47) < 0) {
            LOGGER.warn("The format {} should be a mime type", (Object)this.imageFormat);
            this.imageFormat = "image/" + this.imageFormat;
        }
        Assert.isTrue((this.method == HttpMethod.GET || this.method == HttpMethod.POST ? 1 : 0) != 0, (String)String.format("Unsupported method %s for WMS layer", this.method.toString()));
    }

    public static enum ServerType {
        MAPSERVER,
        GEOSERVER,
        QGISSERVER;

    }
}

