/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wmts;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.vividsolutions.jts.util.Assert;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.mapfish.print.URIUtils;
import org.mapfish.print.map.tiled.AbstractWMXLayerParams;
import org.mapfish.print.map.tiled.wmts.Matrix;
import org.mapfish.print.map.tiled.wmts.RequestEncoding;
import org.mapfish.print.map.tiled.wmts.WMTSLayer;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.wrapper.PObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WMTSLayerParam
extends AbstractWMXLayerParams {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMTSLayerParam.class);
    public String baseURL;
    public String layer;
    @HasDefaultValue
    public String version = "1.0.0";
    @HasDefaultValue
    public RequestEncoding requestEncoding = RequestEncoding.REST;
    @HasDefaultValue
    public String style = "";
    @HasDefaultValue
    public String[] dimensions;
    @HasDefaultValue
    public PObject dimensionParams;
    @HasDefaultValue
    public String imageFormat = "image/png";
    public String matrixSet;
    public Matrix[] matrices;

    @Override
    public String getBaseUrl() {
        return this.baseURL;
    }

    public void postConstruct() {
        Assert.isTrue((boolean)this.validateBaseUrl(), (String)"invalid baseURL");
    }

    @Override
    public String createCommonUrl() throws URISyntaxException {
        if (RequestEncoding.REST == this.requestEncoding) {
            return this.getBaseUrl();
        }
        HashMultimap queryParams = HashMultimap.create();
        queryParams.putAll(this.getCustomParams());
        queryParams.putAll(this.getMergeableParams());
        URI baseUri = new URI(this.getBaseUrl());
        return URIUtils.addParams(this.getBaseUrl(), (Multimap<String, String>)queryParams, (Set<String>)URIUtils.getParameters(baseUri).keySet());
    }

    @Override
    public boolean validateBaseUrl() {
        String url = this.getBaseUrl();
        if (Strings.isNullOrEmpty((String)url)) {
            return false;
        }
        if (RequestEncoding.REST == this.requestEncoding) {
            if (!this.containsVariables(url)) {
                LOGGER.warn("URL {} is missing some variables", (Object)url);
                return false;
            }
            try {
                WMTSLayer.createRestURI("matrix", 0, 0, this);
                return true;
            }
            catch (URISyntaxException exc) {
                LOGGER.warn("URL {} is invalid: {}", (Object)url, (Object)exc.getMessage());
                return false;
            }
        }
        return super.validateBaseUrl();
    }

    private boolean containsVariables(String url) {
        return url.contains("{TileMatrix}") && url.contains("{TileRow}") && url.contains("{TileCol}");
    }
}

