/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.util.Assert;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorExecutionContext;
import org.mapfish.print.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorGraphNode<In, Out> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorGraphNode.class);
    private final Processor<In, Out> processor;
    private final Set<ProcessorGraphNode> dependencies = Sets.newHashSet();
    private final Set<ProcessorGraphNode> requirements = Sets.newHashSet();
    private final MetricRegistry metricRegistry;

    public ProcessorGraphNode(@Nonnull Processor<In, Out> processor, @Nonnull MetricRegistry metricRegistry) {
        this.processor = processor;
        this.metricRegistry = metricRegistry;
    }

    public Processor<?, ?> getProcessor() {
        return this.processor;
    }

    public void addDependency(ProcessorGraphNode node) {
        Assert.isTrue((node != this ? 1 : 0) != 0, (String)"A processor can't depends on himself");
        this.dependencies.add(node);
        node.addRequirement(this);
    }

    private void addRequirement(ProcessorGraphNode node) {
        this.requirements.add(node);
    }

    protected Set<ProcessorGraphNode> getRequirements() {
        return this.requirements;
    }

    protected Set<ProcessorGraphNode> getDependencies() {
        return this.dependencies;
    }

    public boolean hasRequirements() {
        return !this.requirements.isEmpty();
    }

    public Optional<ProcessorNodeForkJoinTask<In, Out>> createTask(@Nonnull ProcessorExecutionContext execContext) {
        if (!execContext.tryStart(this)) {
            return Optional.absent();
        }
        return Optional.of(new ProcessorNodeForkJoinTask(this, execContext));
    }

    @Nonnull
    public BiMap<String, String> getOutputMapper() {
        BiMap<String, String> outputMapper = this.processor.getOutputMapperBiMap();
        if (outputMapper == null) {
            return HashBiMap.create();
        }
        return outputMapper;
    }

    @Nonnull
    public BiMap<String, String> getInputMapper() {
        BiMap<String, String> inputMapper = this.processor.getInputMapperBiMap();
        if (inputMapper == null) {
            return HashBiMap.create();
        }
        return inputMapper;
    }

    public void toString(StringBuilder builder, int indent, String parent) {
        this.processor.toString(builder, indent, parent);
        for (ProcessorGraphNode dependency : this.dependencies) {
            dependency.toString(builder, indent + 1, this.processor.toString());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0, "?");
        return builder.toString();
    }

    public String getName() {
        return this.processor.toString();
    }

    public Set<? extends Processor<?, ?>> getAllProcessors() {
        IdentityHashMap all = new IdentityHashMap();
        all.put(this.getProcessor(), null);
        for (ProcessorGraphNode dependency : this.dependencies) {
            for (Processor<?, ?> p : dependency.getAllProcessors()) {
                all.put(p, null);
            }
        }
        return all.keySet();
    }

    public static final class ProcessorNodeForkJoinTask<In, Out>
    extends RecursiveTask<Values> {
        private final ProcessorExecutionContext execContext;
        private final ProcessorGraphNode<In, Out> node;

        private ProcessorNodeForkJoinTask(ProcessorGraphNode<In, Out> node, ProcessorExecutionContext execContext) {
            this.node = node;
            this.execContext = execContext;
        }

        @Override
        protected Values compute() {
            return this.execContext.getContext().mdcContext(() -> {
                Values values = this.execContext.getValues();
                Processor process = ((ProcessorGraphNode)this.node).processor;
                MetricRegistry registry = ((ProcessorGraphNode)this.node).metricRegistry;
                String name = String.format("%s.compute.%s", ProcessorGraphNode.class.getName(), process.getClass().getName());
                Timer.Context timerContext = registry.timer(name).time();
                try {
                    Object output;
                    Object inputParameter = ProcessorUtils.populateInputParameter(process, values);
                    try {
                        LOGGER.debug("Executing process: {}", (Object)process);
                        output = process.execute(inputParameter, this.execContext.getContext());
                        LOGGER.debug("Succeeded in executing process: {}", (Object)process);
                    }
                    catch (Exception e) {
                        this.execContext.getContext().stopIfCanceled();
                        LOGGER.error("Error while executing process: " + process);
                        registry.counter(name + ".error").inc();
                        throw ExceptionUtils.getRuntimeException(e);
                    }
                    if (output != null) {
                        ProcessorUtils.writeProcessorOutputToValues(output, process, values);
                    }
                }
                finally {
                    this.execContext.finished(this.node);
                    long processorTime = TimeUnit.MILLISECONDS.convert(timerContext.stop(), TimeUnit.NANOSECONDS);
                    LOGGER.info("Time taken to run processor: '{}' was {} ms", process.getClass(), (Object)processorTime);
                }
                this.execContext.getContext().stopIfCanceled();
                ProcessorDependencyGraph.tryExecuteNodes(((ProcessorGraphNode)this.node).dependencies, this.execContext, true);
                return values;
            });
        }
    }
}

