/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import com.google.common.base.Optional;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.mapfish.print.processor.http.matcher.HostMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InetHostMatcher
extends HostMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InetHostMatcher.class);
    private List<AddressMask> authorizedIPs = null;

    private static byte[] mask(byte[] address, byte[] mask) {
        if (mask != null) {
            if (address.length != mask.length) {
                LOGGER.warn("Cannot mask address [{}] with: {}", (Object)Arrays.toString(address), (Object)Arrays.toString(mask));
                return address;
            }
            byte[] result = new byte[address.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(address[i] & mask[i]);
            }
            return result;
        }
        return address;
    }

    @Override
    protected final Optional<Boolean> tryOverrideValidation(MatchInfo matchInfo) throws UnknownHostException, SocketException {
        InetAddress[] requestedIPs;
        String host = matchInfo.getHost();
        if (host == MatchInfo.ANY_HOST) {
            return Optional.absent();
        }
        try {
            requestedIPs = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException ex) {
            return Optional.of((Object)false);
        }
        for (InetAddress requestedIP : requestedIPs) {
            if (!this.isInAuthorized(requestedIP)) continue;
            return Optional.absent();
        }
        return Optional.of((Object)false);
    }

    private boolean isInAuthorized(InetAddress requestedIP) throws UnknownHostException, SocketException {
        List<AddressMask> finalAuthorizedIPs = this.getAuthorizedIPs();
        byte[] address = requestedIP.getAddress();
        for (AddressMask authorizedIP : finalAuthorizedIPs) {
            if (!this.compareIP(address, authorizedIP)) continue;
            return true;
        }
        LOGGER.debug("Address not in the authorized set: {}", (Object)requestedIP);
        return false;
    }

    private boolean compareIP(byte[] requestedIP, AddressMask authorizedIP) {
        if (requestedIP.length != authorizedIP.address.length) {
            return false;
        }
        byte[] maskedRequest = InetHostMatcher.mask(requestedIP, authorizedIP.mask);
        return Arrays.equals(authorizedIP.address, maskedRequest);
    }

    private List<AddressMask> getAuthorizedIPs() throws SocketException, UnknownHostException {
        if (this.authorizedIPs == null) {
            this.authorizedIPs = this.createAuthorizedIPs();
        }
        return this.authorizedIPs;
    }

    protected abstract List<AddressMask> createAuthorizedIPs() throws UnknownHostException, SocketException;

    protected final void clearAuthorizedIPs() {
        this.authorizedIPs = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.authorizedIPs.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetHostMatcher other = (InetHostMatcher)obj;
        return this.authorizedIPs.equals(other.authorizedIPs);
    }

    protected static class AddressMask {
        private final byte[] address;
        @Nullable
        private final byte[] mask;

        public AddressMask(InetAddress ip, InetAddress mask) {
            this.mask = mask != null ? mask.getAddress() : null;
            this.address = InetHostMatcher.mask(ip.getAddress(), this.mask);
        }

        public AddressMask(InetAddress address) {
            if (address.isLoopbackAddress() && address instanceof Inet4Address) {
                int all = -1;
                this.mask = new byte[]{-1, 0, 0, 0};
            } else {
                this.mask = null;
            }
            this.address = InetHostMatcher.mask(address.getAddress(), this.mask);
        }

        public final int hashCode() {
            int prime = 31;
            return Arrays.hashCode(this.address) * 31 + Arrays.hashCode(this.mask);
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddressMask other = (AddressMask)obj;
            return Arrays.equals(this.address, other.address) && Arrays.equals(this.mask, other.mask);
        }
    }
}

