/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.DataSourceAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.Template;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.CustomDependencies;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorDependencyGraphFactory;
import org.mapfish.print.processor.RequireAttributes;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;

public final class DataSourceProcessor
extends AbstractProcessor<Input, Output>
implements RequireAttributes,
CustomDependencies {
    private Map<String, Attribute> internalAttributes = Maps.newHashMap();
    private Map<String, Attribute> allAttributes = Maps.newHashMap();
    @Autowired
    private ProcessorDependencyGraphFactory processorGraphFactory;
    private ProcessorDependencyGraph processorGraph;
    private List<Processor> processors;
    private List<String> copyAttributes = Lists.newArrayList();
    @Autowired
    private JasperReportBuilder jasperReportBuilder;
    private String reportTemplate;
    private String reportKey;

    public DataSourceProcessor() {
        super(Output.class);
    }

    @PostConstruct
    private void init() {
        this.processorGraph = this.processorGraphFactory.build(Collections.emptyList(), Collections.emptyMap());
    }

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public void setProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    public void setAttributes(Map<String, Attribute> attributes) {
        this.internalAttributes = attributes;
        this.allAttributes.putAll(attributes);
    }

    public void setCopyAttributes(List<String> copyAttributes) {
        this.copyAttributes = copyAttributes;
    }

    @Override
    @Nonnull
    public Collection<String> getDependencies() {
        ArrayList<String> result = new ArrayList<String>(this.copyAttributes);
        result.add("tempTaskDirectory");
        result.add("clientHttpRequestFactoryProvider");
        result.add("template");
        result.add("pdfConfig");
        result.add("SUBREPORT_DIR");
        result.add("values");
        result.add("jobId");
        return result;
    }

    @Override
    public void setAttribute(String name, Attribute attribute) {
        if (name.equals("datasource")) {
            this.allAttributes.putAll(((DataSourceAttribute)attribute).getAttributes());
        } else if (this.copyAttributes.contains(name)) {
            this.allAttributes.put(name, attribute);
        }
    }

    @Override
    @Nullable
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    @Nullable
    public Output execute(Input input, Processor.ExecutionContext context) throws Exception {
        JRDataSource jrDataSource = this.processInput(input);
        if (jrDataSource == null) {
            jrDataSource = new JREmptyDataSource();
        }
        return new Output(jrDataSource);
    }

    private JRDataSource processInput(@Nonnull Input input) throws JSONException, JRException {
        ArrayList dataSourceValues = Lists.newArrayList();
        for (Map<String, Object> o : input.datasource.attributesValues) {
            Values rowValues = new Values(input.values);
            for (String string : this.copyAttributes) {
                rowValues.put(string, input.values.getObject(string, Object.class));
            }
            for (Map.Entry entry : o.entrySet()) {
                rowValues.put((String)entry.getKey(), entry.getValue());
            }
            dataSourceValues.add(rowValues);
        }
        ArrayList futures = Lists.newArrayList();
        if (!dataSourceValues.isEmpty()) {
            File reportFile;
            for (Values dataSourceValue : dataSourceValues) {
                this.addAttributes(input.template, dataSourceValue);
                ForkJoinTask taskFuture = this.processorGraph.createTask(dataSourceValue).fork();
                futures.add(taskFuture);
            }
            if (this.reportTemplate != null) {
                Configuration configuration = input.template.getConfiguration();
                File file = new File(configuration.getDirectory(), this.reportTemplate);
                reportFile = this.jasperReportBuilder.compileJasperReport(configuration, file);
            } else {
                reportFile = null;
            }
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            for (ForkJoinTask future : futures) {
                Values rowData = (Values)future.join();
                if (reportFile != null) {
                    rowData.put(this.reportKey, reportFile.getAbsolutePath());
                }
                rows.add(rowData.asMap());
            }
            return new JRMapCollectionDataSource(rows);
        }
        return null;
    }

    private void addAttributes(@Nonnull Template template, @Nonnull Values dataSourceValue) throws JSONException {
        dataSourceValue.populateFromAttributes(template, this.internalAttributes, new PJsonObject(new JSONObject(), "DataSourceProcessorAttributes"));
    }

    @Override
    public void toString(@Nonnull StringBuilder builder, int indent, String parent) {
        super.toString(builder, indent, parent);
        this.processorGraph.toString(builder, indent + 1, this.toString());
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.reportTemplate != null && this.reportKey == null || this.reportTemplate == null && this.reportKey != null) {
            validationErrors.add(new ConfigurationException("'reportKey' and 'reportTemplate' must ither both be null or both be non-null.  reportKey: " + this.reportKey + " reportTemplate: " + this.reportTemplate));
        }
        for (Attribute attribute : this.internalAttributes.values()) {
            attribute.validate(validationErrors, configuration);
        }
        ProcessorDependencyGraphFactory.fillProcessorAttributes(this.processors, this.allAttributes);
        for (Processor processor : this.processors) {
            processor.validate(validationErrors, configuration);
        }
        HashMap attcls = new HashMap();
        for (Map.Entry<String, Attribute> entry : this.allAttributes.entrySet()) {
            attcls.put(entry.getKey(), entry.getValue().getValueType());
        }
        try {
            this.processorGraph = this.processorGraphFactory.build(this.processors, attcls);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            validationErrors.add(illegalArgumentException);
        }
        if (this.processorGraph == null) {
            validationErrors.add(new ConfigurationException("There are no child processors for this processor"));
        } else {
            Set<Processor<?, ?>> set = this.processorGraph.getAllProcessors();
            for (Processor<?, ?> processor : set) {
                processor.validate(validationErrors, configuration);
            }
        }
    }

    public static final class Output {
        public final JRDataSource jrDataSource;

        public Output(@Nonnull JRDataSource datasource) {
            this.jrDataSource = datasource;
        }
    }

    public static final class Input {
        public Template template;
        public Values values;
        public DataSourceAttribute.DataSourceAttributeValue datasource;
    }
}

