/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.base.Strings;
import com.google.common.io.Closer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.ImageUtils;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.style.json.ColorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public final class NorthArrowGraphic {
    private static final Logger LOGGER = LoggerFactory.getLogger(NorthArrowGraphic.class);
    private static final String DEFAULT_GRAPHIC = "NorthArrow_10.svg";
    private static final String SVG_NS = "http://www.w3.org/2000/svg";

    private NorthArrowGraphic() {
    }

    public static URI create(Dimension targetSize, String graphicFile, Color backgroundColor, Double rotation, File workingDir, MfClientHttpRequestFactory clientHttpRequestFactory) throws Exception {
        try (Closer closer = Closer.create();){
            RasterReference input = NorthArrowGraphic.loadGraphic(graphicFile, clientHttpRequestFactory, closer);
            if (graphicFile == null || graphicFile.toLowerCase().trim().endsWith("svg")) {
                URI uRI = NorthArrowGraphic.createSvg(targetSize, input, rotation, backgroundColor, workingDir);
                return uRI;
            }
            URI uRI = NorthArrowGraphic.createRaster(targetSize, input, rotation, backgroundColor, workingDir);
            return uRI;
        }
    }

    private static RasterReference loadGraphic(String graphicFile, MfClientHttpRequestFactory clientHttpRequestFactory, Closer closer) throws IOException, URISyntaxException {
        if (Strings.isNullOrEmpty((String)graphicFile)) {
            URL file = NorthArrowGraphic.class.getResource(DEFAULT_GRAPHIC);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(file.toURI())));
            return new RasterReference((InputStream)closer.register((Closeable)inputStream), file.toURI());
        }
        URI uri = graphicFile.startsWith("file:") ? new URI(graphicFile.replace("\\", "/")) : new URI(graphicFile);
        ClientHttpRequest request = clientHttpRequestFactory.createRequest(uri, HttpMethod.GET);
        ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)request.execute());
        return new RasterReference(new BufferedInputStream(response.getBody()), uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI createRaster(Dimension targetSize, RasterReference rasterReference, Double rotation, Color backgroundColor, File workingDir) throws IOException {
        File path = File.createTempFile("north-arrow-", ".tiff", workingDir);
        BufferedImage newImage = new BufferedImage(targetSize.width, targetSize.height, 6);
        Graphics2D graphics2d = newImage.createGraphics();
        try {
            int newHeight;
            int newWidth;
            BufferedImage originalImage = ImageIO.read(rasterReference.inputStream);
            if (originalImage == null) {
                LOGGER.warn("Unable to load NorthArrow graphic: {}, it is not an image format that can be decoded", (Object)rasterReference.uri);
                throw new IllegalArgumentException();
            }
            graphics2d.setColor(backgroundColor);
            graphics2d.fillRect(0, 0, targetSize.width, targetSize.height);
            if (originalImage.getWidth() > originalImage.getHeight()) {
                newWidth = targetSize.width;
                newHeight = Math.min(targetSize.height, (int)Math.ceil((double)newWidth / ((double)originalImage.getWidth() / (double)originalImage.getHeight())));
            } else {
                newHeight = targetSize.height;
                newWidth = Math.min(targetSize.width, (int)Math.ceil((double)newHeight / ((double)originalImage.getHeight() / (double)originalImage.getWidth())));
            }
            int deltaX = (int)Math.floor((double)(targetSize.width - newWidth) / 2.0);
            int deltaY = (int)Math.floor((double)(targetSize.height - newHeight) / 2.0);
            if (!FloatingPointUtil.equals(rotation, 0.0)) {
                AffineTransform rotate = AffineTransform.getRotateInstance(rotation, (double)targetSize.width / 2.0, (double)targetSize.height / 2.0);
                graphics2d.setTransform(rotate);
            }
            graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2d.drawImage(originalImage, deltaX, deltaY, newWidth, newHeight, null);
            ImageUtils.writeImage(newImage, "tiff", path);
        }
        finally {
            graphics2d.dispose();
        }
        return path.toURI();
    }

    private static URI createSvg(Dimension targetSize, RasterReference rasterReference, Double rotation, Color backgroundColor, File workingDir) throws IOException {
        SVGElement svgRoot = NorthArrowGraphic.parseSvg(rasterReference.inputStream);
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document newDocument = impl.createDocument(SVG_NS, "svg", null);
        SVGElement newSvgRoot = (SVGElement)newDocument.getDocumentElement();
        newSvgRoot.setAttributeNS(null, "width", Integer.toString(targetSize.width));
        newSvgRoot.setAttributeNS(null, "height", Integer.toString(targetSize.height));
        NorthArrowGraphic.setSvgBackground(backgroundColor, targetSize, newDocument, newSvgRoot);
        NorthArrowGraphic.embedSvgGraphic(svgRoot, newSvgRoot, newDocument, targetSize, rotation);
        File path = NorthArrowGraphic.writeSvgToFile(newDocument, workingDir);
        return path.toURI();
    }

    private static void setSvgBackground(Color backgroundColor, Dimension targetSize, Document newDocument, SVGElement newSvgRoot) {
        Element rect = newDocument.createElementNS(SVG_NS, "rect");
        rect.setAttributeNS(null, "x", "0");
        rect.setAttributeNS(null, "y", "0");
        rect.setAttributeNS(null, "width", Integer.toString(targetSize.width));
        rect.setAttributeNS(null, "height", Integer.toString(targetSize.height));
        String bgColor = ColorParser.toRGB(backgroundColor);
        rect.setAttributeNS(null, "fill", bgColor);
        String opacity = Double.toString((double)backgroundColor.getAlpha() / 255.0);
        rect.setAttributeNS(null, "fill-opacity", opacity);
        newSvgRoot.appendChild((Node)rect);
    }

    private static void embedSvgGraphic(SVGElement svgRoot, SVGElement newSvgRoot, Document newDocument, Dimension targetSize, Double rotation) {
        String originalWidth = svgRoot.getAttributeNS(null, "width");
        String originalHeight = svgRoot.getAttributeNS(null, "height");
        if (!Strings.isNullOrEmpty((String)originalWidth) && !Strings.isNullOrEmpty((String)originalHeight)) {
            Element wrapperContainer = newDocument.createElementNS(SVG_NS, "g");
            wrapperContainer.setAttributeNS(null, "transform", NorthArrowGraphic.getRotateTransformation(targetSize, rotation));
            newSvgRoot.appendChild((Node)wrapperContainer);
            Element wrapperSvg = newDocument.createElementNS(SVG_NS, "svg");
            wrapperSvg.setAttributeNS(null, "width", "100%");
            wrapperSvg.setAttributeNS(null, "height", "100%");
            wrapperSvg.setAttributeNS(null, "viewBox", "0 0 " + originalWidth + " " + originalHeight);
            wrapperContainer.appendChild(wrapperSvg);
            Node svgRootImported = newDocument.importNode((Node)svgRoot, true);
            wrapperSvg.appendChild(svgRootImported);
        } else if (Strings.isNullOrEmpty((String)originalWidth) && Strings.isNullOrEmpty((String)originalHeight)) {
            Element wrapperContainer = newDocument.createElementNS(SVG_NS, "g");
            wrapperContainer.setAttributeNS(null, "transform", NorthArrowGraphic.getRotateTransformation(targetSize, rotation));
            newSvgRoot.appendChild((Node)wrapperContainer);
            Node svgRootImported = newDocument.importNode((Node)svgRoot, true);
            wrapperContainer.appendChild(svgRootImported);
        } else {
            throw new IllegalArgumentException("Unsupported or invalid north-arrow SVG graphic: The same unit (px, em, %, ...) must be used for `width` and `height`.");
        }
    }

    private static String getRotateTransformation(Dimension targetSize, double rotation) {
        return "rotate(" + Double.toString(Math.toDegrees(rotation)) + " " + Integer.toString(targetSize.width / 2) + " " + Integer.toString(targetSize.height / 2) + ")";
    }

    private static SVGElement parseSvg(InputStream inputStream) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        SVGDocument document = (SVGDocument)f.createDocument("", inputStream);
        return (SVGElement)document.getDocumentElement();
    }

    private static File writeSvgToFile(Document document, File workingDir) throws IOException {
        File path = File.createTempFile("north-arrow-", ".svg", workingDir);
        try (FileWriterWithEncoding fw = new FileWriterWithEncoding(path, Charset.forName("UTF-8").newEncoder());){
            DOMUtilities.writeDocument((Document)document, (Writer)fw);
            fw.flush();
        }
        return path;
    }

    private static final class RasterReference {
        private final InputStream inputStream;
        private final URI uri;

        private RasterReference(InputStream inputStream, URI uri) {
            this.inputStream = inputStream;
            this.uri = uri;
        }
    }
}

