/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.springframework.beans.factory.annotation.Autowired;

public class Accounting {
    @Autowired
    private MetricRegistry metricRegistry;

    public JobTracker startJob(PrintJobEntry entry, Configuration configuration) {
        return new JobTracker(entry, configuration);
    }

    public class JobTracker {
        protected final PrintJobEntry entry;
        protected final Configuration configuration;
        protected final Timer.Context successTimer;

        protected JobTracker(PrintJobEntry entry, Configuration configuration) {
            this.entry = entry;
            this.configuration = configuration;
            this.successTimer = Accounting.this.metricRegistry.timer(this.getClass().getName() + "." + this.entry.getAppId() + ".success").time();
        }

        public long onJobSuccess(PrintJob.PrintResult printResult) {
            return this.successTimer.stop();
        }

        public void onJobCancel() {
            Accounting.this.metricRegistry.counter(this.getClass().getName() + "." + this.entry.getAppId() + ".cancel").inc();
        }

        public void onJobError() {
            Accounting.this.metricRegistry.counter(this.getClass().getName() + "." + this.entry.getAppId() + ".error").inc();
        }
    }
}

