/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geotools.styling.Style;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public final class ParserPluginUtils {
    private ParserPluginUtils() {
    }

    public static Optional<Style> loadStyleAsURI(ClientHttpRequestFactory clientHttpRequestFactory, String styleRef, Function<byte[], @Nullable Optional<Style>> loadFunction) {
        byte[] input;
        HttpStatus statusCode;
        URI uri;
        try {
            uri = new URI(styleRef);
        }
        catch (URISyntaxException e) {
            uri = new File(styleRef).toURI();
        }
        try {
            ClientHttpRequest request = clientHttpRequestFactory.createRequest(uri, HttpMethod.GET);
            try (ClientHttpResponse response = request.execute();){
                statusCode = response.getStatusCode();
                input = IOUtils.toByteArray((InputStream)response.getBody());
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        if (statusCode == HttpStatus.OK) {
            return loadFunction.apply(input);
        }
        return Optional.empty();
    }
}

