/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.StyleHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.RendererUtilities;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.ImageUtils;
import org.mapfish.print.SvgUtil;
import org.mapfish.print.attribute.map.AreaOfInterest;
import org.mapfish.print.attribute.map.BBoxMapBounds;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomToFeatures;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.HttpRequestFetcher;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.Scale;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.FeatureLayer;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InputOutputValue;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.map.ConstantClipGraphics2D;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;

public final class CreateMapProcessor
extends AbstractProcessor<Input, Output> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateMapProcessor.class);
    @Autowired
    FeatureLayer.Plugin featureLayerPlugin;
    @Autowired
    private MetricRegistry metricRegistry;
    @Resource(name="requestForkJoinPool")
    private ForkJoinPool requestForkJoinPool;

    protected CreateMapProcessor() {
        super(Output.class);
    }

    private static MapLayer.RenderType getSupportedRenderType(MapLayer.RenderType renderType) {
        if (renderType == MapLayer.RenderType.UNKNOWN || renderType == MapLayer.RenderType.TIFF) {
            return MapLayer.RenderType.PNG;
        }
        return renderType;
    }

    @VisibleForTesting
    public static MapfishMapContext createMapContext(MapAttribute.MapAttributeValues mapValues) {
        Dimension mapSize = mapValues.getMapSize();
        java.awt.Rectangle paintArea = new java.awt.Rectangle(mapSize);
        double dpi = mapValues.getDpi();
        MapBounds bounds = mapValues.getMapBounds();
        bounds = CreateMapProcessor.adjustBoundsToScaleAndMapSize(mapValues, paintArea, bounds, dpi);
        double dpiRatio = dpi / 72.0;
        paintArea.setBounds(0, 0, (int)Math.ceil(mapSize.getWidth() * dpiRatio), (int)Math.ceil(mapSize.getHeight() * dpiRatio));
        return new MapfishMapContext(bounds, paintArea.getSize(), mapValues.getRotation(), dpi, mapValues.longitudeFirst, mapValues.isDpiSensitiveStyle());
    }

    public static MapBounds adjustBoundsToScaleAndMapSize(GenericMapAttribute.GenericMapAttributeValues mapValues, java.awt.Rectangle paintArea, MapBounds bounds, double dpi) {
        MapBounds newBounds = bounds;
        if (mapValues.isUseNearestScale().booleanValue()) {
            newBounds = newBounds.adjustBoundsToNearestScale(mapValues.getZoomLevels(), mapValues.getZoomSnapTolerance(), mapValues.getZoomLevelSnapStrategy(), mapValues.getZoomSnapGeodetic(), paintArea, dpi);
        }
        newBounds = new BBoxMapBounds(newBounds.toReferencedEnvelope(paintArea));
        if (mapValues.isUseAdjustBounds().booleanValue()) {
            newBounds = newBounds.adjustedEnvelope(paintArea);
        }
        return newBounds;
    }

    public static SVGGraphics2D createSvgGraphics(Dimension size) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document document = db.getDOMImplementation().createDocument(null, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((org.w3c.dom.Document)document);
        ctx.setStyleHandler((StyleHandler)new OpacityAdjustingStyleHandler());
        ctx.setComment("Generated by GeoTools2 with Batik SVG Generator");
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, true);
        g2d.setSVGCanvasSize(size);
        return g2d;
    }

    public static void saveSvgFile(SVGGraphics2D graphics2d, File path) throws IOException {
        try (FileOutputStream fs = new FileOutputStream(path);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fs, "UTF-8");
             BufferedWriter osw = new BufferedWriter(outputStreamWriter);){
            graphics2d.stream((Writer)osw, true);
        }
    }

    @Override
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    public Output execute(Input param, Processor.ExecutionContext context) throws Exception {
        context.stopIfCanceled();
        MapAttribute.MapAttributeValues mapValues = (MapAttribute.MapAttributeValues)param.map;
        if (mapValues.zoomToFeatures != null) {
            this.zoomToFeatures(param.clientHttpRequestFactoryProvider.get(), mapValues, context);
        }
        MapfishMapContext mapContext = CreateMapProcessor.createMapContext(mapValues);
        List<URI> graphics = this.createLayerGraphics(param.tempTaskDirectory, param.clientHttpRequestFactoryProvider.get(), mapValues, context, mapContext);
        context.stopIfCanceled();
        URI mapSubReport = param.map.getTemplate().isMapExport() ? this.createMergedGraphic(param.tempTaskDirectory, graphics, mapContext, param.outputFormat) : this.createMapSubReport(param.tempTaskDirectory, mapValues.getMapSize(), graphics, mapValues.getDpi());
        context.getStats().addMapStats(mapContext, mapValues);
        return new Output(graphics, mapSubReport.toString(), mapContext);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI createMergedGraphic(File printDirectory, List<URI> graphics, MapfishMapContext mapContext, String outputFormat) throws IOException, JRException {
        File mergedGraphic;
        block13: {
            mergedGraphic = File.createTempFile("map-", "." + outputFormat, printDirectory);
            int width = mapContext.getMapSize().width;
            int height = mapContext.getMapSize().height;
            if ("pdf".equalsIgnoreCase(outputFormat)) {
                try (Document document = new Document(new Rectangle((float)width, (float)height));){
                    PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(mergedGraphic));
                    document.open();
                    PdfContentByte pdfCB = writer.getDirectContent();
                    Graphics2D g = pdfCB.createGraphics((float)width, (float)height);
                    try {
                        this.drawGraphics(width, height, graphics, g);
                        break block13;
                    }
                    finally {
                        g.dispose();
                    }
                }
            }
            boolean isJpeg = MapLayer.RenderType.fromFileExtension(outputFormat) == MapLayer.RenderType.JPEG;
            BufferedImage bufferedImage = new BufferedImage(width, height, isJpeg ? 5 : 6);
            Graphics g = bufferedImage.getGraphics();
            if (isJpeg) {
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, width, height);
            }
            try {
                this.drawGraphics(width, height, graphics, g);
            }
            finally {
                g.dispose();
            }
            ImageUtils.writeImage(bufferedImage, outputFormat, mergedGraphic);
        }
        return mergedGraphic.toURI();
    }

    private void drawGraphics(int width, int height, List<URI> graphics, Graphics g) throws IOException {
        for (URI graphic : graphics) {
            File graphicFile = new File(graphic);
            if (FilenameUtils.getExtension((String)graphicFile.getName()).equals("svg")) {
                try {
                    g.drawImage(SvgUtil.convertFromSvg(graphic, width, height), 0, 0, width, height, null);
                    continue;
                }
                catch (TranscoderException e) {
                    throw new IllegalStateException(e);
                }
            }
            BufferedImage image = ImageIO.read(graphicFile);
            g.drawImage(image, 0, 0, width, height, null);
        }
    }

    private URI createMapSubReport(File printDirectory, Dimension mapSize, List<URI> graphics, double dpi) throws IOException, JRException {
        ImagesSubReport subReport = new ImagesSubReport(graphics, mapSize, dpi);
        File compiledReport = File.createTempFile("map-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    private void warnIfDifferentRenderType(MapLayer.RenderType renderType, MapLayer layer) {
        if (renderType != layer.getRenderType()) {
            LOGGER.info("Layer {} has {} format, storing as PNG.", (Object)layer.getName(), (Object)layer.getRenderType().toString());
        }
    }

    private MapfishMapContext getTransformer(MapfishMapContext mapContext, double imageBufferScaling) {
        return new MapfishMapContext(mapContext, mapContext.getBounds(), new Dimension((int)Math.round((double)mapContext.getMapSize().width * imageBufferScaling), (int)Math.round((double)mapContext.getMapSize().height * imageBufferScaling)), mapContext.getRotation(), mapContext.getDPI(), mapContext.isForceLongitudeFirst(), mapContext.isDpiSensitiveStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<URI> createLayerGraphics(File printDirectory, MfClientHttpRequestFactory clientHttpRequestFactory, MapAttribute.MapAttributeValues mapValues, Processor.ExecutionContext context, MapfishMapContext mapContext) throws Exception {
        ArrayList<MapLayer> layers = new ArrayList<MapLayer>(mapValues.getLayers());
        Collections.reverse(layers);
        AreaOfInterest areaOfInterest = this.addAreaOfInterestLayer(mapValues, layers);
        String mapKey = UUID.randomUUID().toString();
        ArrayList<URI> graphics = new ArrayList<URI>(layers.size());
        HttpRequestFetcher cache = new HttpRequestFetcher(printDirectory, this.metricRegistry, context, this.requestForkJoinPool);
        for (MapLayer layer : layers) {
            layer.prepareRender(mapContext);
            MapfishMapContext transformer = this.getTransformer(mapContext, layer.getImageBufferScaling());
            layer.prefetchResources(cache, clientHttpRequestFactory, transformer, context);
        }
        Timer.Context timer = this.metricRegistry.timer(this.getClass().getName() + ".buildLayers").time();
        int fileNumber = 0;
        for (LayerGroup layerGroup : LayerGroup.buildGroups(layers)) {
            File path;
            if (layerGroup.renderType == MapLayer.RenderType.SVG) {
                for (MapLayer layer : layerGroup.layers) {
                    context.stopIfCanceled();
                    SVGGraphics2D graphics2D = CreateMapProcessor.createSvgGraphics(mapContext.getMapSize());
                    try {
                        Graphics2D clippedGraphics2D = this.createClippedGraphics(mapContext, areaOfInterest, (Graphics2D)graphics2D);
                        layer.render(clippedGraphics2D, clientHttpRequestFactory, mapContext, context);
                        path = new File(printDirectory, mapKey + "_layer_" + fileNumber++ + ".svg");
                        CreateMapProcessor.saveSvgFile(graphics2D, path);
                        graphics.add(path.toURI());
                    }
                    finally {
                        graphics2D.dispose();
                    }
                }
                continue;
            }
            BufferedImage bufferedImage = new BufferedImage((int)Math.round((double)mapContext.getMapSize().width * layerGroup.imageBufferScaling), (int)Math.round((double)mapContext.getMapSize().height * layerGroup.imageBufferScaling), layerGroup.opaque ? 5 : 6);
            Graphics2D graphics2D = this.createClippedGraphics(mapContext, areaOfInterest, bufferedImage.createGraphics());
            try {
                if (layerGroup.opaque) {
                    Color prevColor = graphics2D.getColor();
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                    graphics2D.setColor(prevColor);
                }
                MapfishMapContext transformer = this.getTransformer(mapContext, layerGroup.imageBufferScaling);
                for (MapLayer cur : layerGroup.layers) {
                    context.stopIfCanceled();
                    this.warnIfDifferentRenderType(layerGroup.renderType, cur);
                    cur.render(graphics2D, clientHttpRequestFactory, transformer, context);
                }
                String formatName = layerGroup.opaque && layerGroup.renderType == MapLayer.RenderType.JPEG ? "JPEG" : "PNG";
                path = new File(printDirectory, String.format("%s_layer_%d.%s", mapKey, fileNumber++, formatName.toLowerCase()));
                ImageUtils.writeImage(bufferedImage, formatName, path);
                graphics.add(path.toURI());
            }
            finally {
                graphics2D.dispose();
            }
        }
        timer.stop();
        return graphics;
    }

    private AreaOfInterest addAreaOfInterestLayer(@Nonnull MapAttribute.MapAttributeValues mapValues, @Nonnull List<MapLayer> layers) throws IOException {
        AreaOfInterest areaOfInterest = mapValues.areaOfInterest;
        if (areaOfInterest != null && areaOfInterest.display == AreaOfInterest.AoiDisplay.RENDER) {
            FeatureLayer.FeatureLayerParam param = new FeatureLayer.FeatureLayerParam();
            param.defaultStyle = "overview-map:" + areaOfInterest.getArea().getClass().getSimpleName();
            param.style = areaOfInterest.style;
            param.renderAsSvg = areaOfInterest.renderAsSvg;
            param.features = areaOfInterest.areaToFeatureCollection(mapValues);
            FeatureLayer featureLayer = this.featureLayerPlugin.parse(mapValues.getTemplate(), param);
            layers.add(featureLayer);
        }
        return areaOfInterest;
    }

    private Graphics2D createClippedGraphics(@Nonnull MapfishMapContext transformer, @Nullable AreaOfInterest areaOfInterest, @Nonnull Graphics2D graphics2D) {
        if (areaOfInterest != null && areaOfInterest.display == AreaOfInterest.AoiDisplay.CLIP) {
            Polygon screenGeometry = this.areaOfInterestInScreenCRS(transformer, areaOfInterest);
            ShapeWriter shapeWriter = new ShapeWriter();
            Shape clipShape = shapeWriter.toShape((Geometry)screenGeometry);
            return new ConstantClipGraphics2D(graphics2D, clipShape);
        }
        return graphics2D;
    }

    private Polygon areaOfInterestInScreenCRS(@Nonnull MapfishMapContext transformer, @Nullable AreaOfInterest areaOfInterest) {
        if (areaOfInterest != null) {
            Polygon screenGeometry;
            AffineTransform worldToScreenTransform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)transformer.toReferencedEnvelope(), (java.awt.Rectangle)transformer.getPaintArea());
            AffineTransform2D mathTransform = new AffineTransform2D(worldToScreenTransform);
            try {
                screenGeometry = (Polygon)JTS.transform((Geometry)areaOfInterest.getArea(), (MathTransform)mathTransform);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
            return screenGeometry;
        }
        return null;
    }

    private void zoomToFeatures(MfClientHttpRequestFactory clientHttpRequestFactory, MapAttribute.MapAttributeValues mapValues, Processor.ExecutionContext context) {
        ReferencedEnvelope bounds = this.getFeatureBounds(clientHttpRequestFactory, mapValues, context);
        if (bounds != null && !bounds.isNull()) {
            if (mapValues.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.CENTER) {
                Coordinate center = bounds.centre();
                mapValues.center = new double[]{center.x, center.y};
                if (mapValues.zoomToFeatures.minScale != null) {
                    LOGGER.warn("The map.zoomToFeatures.minScale is deprecated, please use directly the map.scale");
                    mapValues.scale = mapValues.zoomToFeatures.minScale;
                }
                mapValues.recalculateBounds();
            } else if (mapValues.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.EXTENT) {
                if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                    Coordinate center = bounds.centre();
                    mapValues.center = new double[]{center.x, center.y};
                    mapValues.bbox = null;
                    mapValues.scale = mapValues.zoomToFeatures.minScale;
                    mapValues.recalculateBounds();
                } else {
                    mapValues.bbox = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()};
                    mapValues.center = null;
                    mapValues.recalculateBounds();
                    MapBounds mapBounds = mapValues.getMapBounds();
                    java.awt.Rectangle paintArea = new java.awt.Rectangle(mapValues.getMapSize());
                    if (mapValues.zoomToFeatures.minMargin != null) {
                        mapBounds = new BBoxMapBounds(mapBounds.toReferencedEnvelope(paintArea)).expand(mapValues.zoomToFeatures.minMargin, paintArea);
                    }
                    mapBounds = mapBounds.adjustedEnvelope(paintArea);
                    Scale scale = mapBounds.getScale(paintArea, mapValues.getDpi());
                    Scale minScale = new Scale((double)mapValues.zoomToFeatures.minScale, mapValues.getMapBounds().getProjection(), (double)mapValues.getDpi());
                    if (scale.getResolution() < minScale.getResolution()) {
                        mapBounds = mapBounds.zoomToScale(minScale);
                    }
                    if (mapValues.isUseNearestScale().booleanValue()) {
                        mapBounds = mapBounds.adjustBoundsToNearestScale(mapValues.getZoomLevels(), 0.0, ZoomLevelSnapStrategy.HIGHER_SCALE, mapValues.getZoomSnapGeodetic(), paintArea, mapValues.getDpi());
                    }
                    mapValues.setMapBounds(mapBounds);
                }
            }
        }
    }

    private ReferencedEnvelope getFeatureBounds(MfClientHttpRequestFactory clientHttpRequestFactory, MapAttribute.MapAttributeValues mapValues, Processor.ExecutionContext context) {
        MapfishMapContext mapContext = CreateMapProcessor.createMapContext(mapValues);
        String layerName = mapValues.zoomToFeatures.layer;
        ReferencedEnvelope bounds = null;
        for (MapLayer layer : mapValues.getLayers()) {
            FeatureCollection features;
            context.stopIfCanceled();
            if ((StringUtils.isEmpty((String)layerName) || !layerName.equals(layer.getName())) && (!StringUtils.isEmpty((String)layerName) || !(layer instanceof AbstractFeatureSourceLayer))) continue;
            AbstractFeatureSourceLayer featureLayer = (AbstractFeatureSourceLayer)layer;
            FeatureSource<?, ?> featureSource = featureLayer.getFeatureSource(clientHttpRequestFactory, mapContext);
            try {
                features = featureSource.getFeatures();
            }
            catch (IOException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
            if (features.isEmpty()) continue;
            if (bounds == null) {
                bounds = features.getBounds();
                continue;
            }
            bounds.expandToInclude((Envelope)features.getBounds());
        }
        return bounds;
    }

    private static final class LayerGroup {
        public final List<MapLayer> layers = new ArrayList<MapLayer>();
        public final MapLayer.RenderType renderType;
        public final double imageBufferScaling;
        public boolean opaque = false;

        private LayerGroup(MapLayer.RenderType renderType, double imageBufferScaling) {
            this.renderType = renderType;
            this.imageBufferScaling = imageBufferScaling;
        }

        public static List<LayerGroup> buildGroups(List<MapLayer> layers) {
            ArrayList<LayerGroup> result = new ArrayList<LayerGroup>();
            int i = 0;
            while (i < layers.size()) {
                MapLayer.RenderType renderType = CreateMapProcessor.getSupportedRenderType(layers.get(i).getRenderType());
                double imageBufferScaling = layers.get(i).getImageBufferScaling();
                LayerGroup group = new LayerGroup(renderType, imageBufferScaling);
                boolean bl = group.opaque = i == 0 && renderType == MapLayer.RenderType.JPEG;
                while (i < layers.size() && CreateMapProcessor.getSupportedRenderType(layers.get(i).getRenderType()) == renderType && imageBufferScaling == layers.get(i).getImageBufferScaling()) {
                    MapLayer toAdd = layers.get(i);
                    group.layers.add(toAdd);
                    group.opaque = group.opaque || renderType == MapLayer.RenderType.JPEG && toAdd.getOpacity() == 1.0;
                    ++i;
                }
                result.add(group);
            }
            return result;
        }
    }

    private static final class OpacityAdjustingStyleHandler
    extends DefaultStyleHandler {
        private OpacityAdjustingStyleHandler() {
        }

        public void setStyle(Element element, Map styleMap, SVGGeneratorContext generatorContext) {
            String tagName = element.getTagName();
            for (Object o : styleMap.keySet()) {
                String styleName = (String)o;
                if (element.getAttributeNS(null, styleName).length() != 0) continue;
                if (styleName.equals("opacity")) {
                    if (!this.appliesTo(styleName, tagName)) continue;
                    element.setAttributeNS(null, "fill-opacity", (String)styleMap.get(styleName));
                    element.setAttributeNS(null, "stroke-opacity", (String)styleMap.get(styleName));
                    continue;
                }
                if (!this.appliesTo(styleName, tagName)) continue;
                element.setAttributeNS(null, styleName, (String)styleMap.get(styleName));
            }
        }
    }

    public static final class Output {
        @InternalValue
        public final List<URI> layerGraphics;
        public final String mapSubReport;
        public final MapfishMapContext mapContext;

        private Output(List<URI> layerGraphics, String mapSubReport, MapfishMapContext mapContext) {
            this.layerGraphics = layerGraphics;
            this.mapSubReport = mapSubReport;
            this.mapContext = mapContext;
        }
    }

    public static class Input {
        public MfClientHttpRequestFactoryProvider clientHttpRequestFactoryProvider;
        @InputOutputValue
        public GenericMapAttribute.GenericMapAttributeValues map;
        public File tempTaskDirectory;
        @HasDefaultValue
        public String outputFormat = null;
    }
}

