/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.SmtpConfig;
import org.mapfish.print.config.Template;
import org.mapfish.print.config.WorkingDirectories;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.processor.ExecutionStats;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.servlet.job.Accounting;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class PrintJob
implements Callable<PrintJobResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintJob.class);
    private PrintJobEntry entry;
    @Autowired
    private MapPrinterFactory mapPrinterFactory;
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired
    private Accounting accounting;
    @Autowired
    private WorkingDirectories workingDirectories;
    private SecurityContext securityContext;

    private static String getFileName(@Nullable MapPrinter mapPrinter, PJsonObject spec) {
        String fileName = spec.optString("outputFilename");
        if (fileName != null) {
            return fileName;
        }
        if (mapPrinter != null) {
            String templateName;
            Configuration config = mapPrinter.getConfiguration();
            Template template = config.getTemplate(templateName = spec.getString("layout"));
            if (template.getOutputFilename() != null) {
                return template.getOutputFilename();
            }
            if (config.getOutputFilename() != null) {
                return config.getOutputFilename();
            }
        }
        return "mapfish-print-report";
    }

    public final PrintJobEntry getEntry() {
        return this.entry;
    }

    public final void setEntry(PrintJobEntry entry) {
        this.entry = entry;
    }

    protected File getReportFile() {
        return new File(this.workingDirectories.getReports(), this.getEntry().getReferenceId());
    }

    protected PrintResult withOpenOutputStream(PrintAction function) throws Exception {
        Processor.ExecutionContext executionContext;
        File reportFile = this.getReportFile();
        try (FileOutputStream out = new FileOutputStream(reportFile);
             BufferedOutputStream bout = new BufferedOutputStream(out);){
            executionContext = function.run(bout);
        }
        return new PrintResult(reportFile.length(), executionContext);
    }

    protected abstract PrintJobResult createResult(String var1, String var2, String var3) throws URISyntaxException, IOException;

    @Override
    public final PrintJobResult call() throws Exception {
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        Timer.Context timer = this.metricRegistry.timer(this.getClass().getName() + ".call").time();
        MDC.put((String)"job_id", (String)this.entry.getReferenceId());
        LOGGER.info("Starting print job {}", (Object)this.entry.getReferenceId());
        MapPrinter mapPrinter = this.mapPrinterFactory.create(this.entry.getAppId());
        Accounting.JobTracker jobTracker = this.accounting.startJob(this.entry, mapPrinter.getConfiguration());
        try {
            PJsonObject spec = this.entry.getRequestData();
            PrintResult report = this.withOpenOutputStream(outputStream -> mapPrinter.print(this.entry.getReferenceId(), this.entry.getRequestData(), outputStream));
            this.metricRegistry.counter(this.getClass().getName() + ".success").inc();
            LOGGER.info("Successfully completed print job {}", (Object)this.entry.getReferenceId());
            LOGGER.debug("Job {}\n{}", (Object)this.entry.getReferenceId(), (Object)this.entry.getRequestData());
            String fileName = PrintJob.getFileName(mapPrinter, spec);
            OutputFormat outputFormat = mapPrinter.getOutputFormat(spec);
            String mimeType = outputFormat.getContentType();
            String fileExtension = outputFormat.getFileSuffix();
            boolean sent = this.maybeSendResult(mapPrinter.getConfiguration(), fileName, fileExtension, mimeType, report.executionContext.getStats());
            jobTracker.onJobSuccess(report);
            PrintJobResult printJobResult = sent ? null : this.createResult(fileName, fileExtension, mimeType);
            return printJobResult;
        }
        catch (Exception e) {
            String canceledText = "";
            if (Thread.currentThread().isInterrupted()) {
                canceledText = "(canceled) ";
                this.metricRegistry.counter(this.getClass().getName() + ".canceled").inc();
                jobTracker.onJobCancel();
            } else {
                this.metricRegistry.counter(this.getClass().getName() + ".error").inc();
                jobTracker.onJobError();
            }
            this.deleteReport();
            LOGGER.warn("Error executing print job {} {}\n{}", new Object[]{this.entry.getRequestData(), canceledText, this.entry.getReferenceId(), e});
            throw e;
        }
        finally {
            long totalTimeMS = System.currentTimeMillis() - this.entry.getStartTime();
            long computationTimeMs = TimeUnit.MILLISECONDS.convert(timer.stop(), TimeUnit.NANOSECONDS);
            this.metricRegistry.timer(this.getClass().getName() + ".total").update(totalTimeMS, TimeUnit.MILLISECONDS);
            this.metricRegistry.timer(this.getClass().getName() + ".wait").update(totalTimeMS - computationTimeMs, TimeUnit.MILLISECONDS);
            LOGGER.debug("Print Job {} completed in {}ms", (Object)this.entry.getReferenceId(), (Object)computationTimeMs);
            MDC.remove((String)"job_id");
        }
    }

    private boolean maybeSendResult(Configuration configuration, String fileName, String fileExtension, String mimeType, ExecutionStats stats) throws IOException, MessagingException {
        PJsonObject requestData = this.entry.getRequestData();
        SmtpConfig smtp = configuration.getSmtp();
        PJsonObject requestSmtp = requestData.optJSONObject("smtp");
        if (smtp == null || requestSmtp == null) {
            return false;
        }
        this.sendEmail(smtp, requestSmtp, fileName, fileExtension, mimeType, stats);
        this.deleteReport();
        return true;
    }

    private void sendEmail(SmtpConfig config, PJsonObject request, String fileName, String fileExtension, String mimeType, ExecutionStats stats) throws MessagingException, IOException {
        Session session = this.createEmailSession(config);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(config.getFromAddress()));
        String to = request.getString("to");
        InternetAddress[] recipients = InternetAddress.parse((String)to);
        message.setRecipients(Message.RecipientType.TO, (Address[])recipients);
        message.setSubject(request.optString("subject", config.getSubject()));
        String msg = request.optString("body", config.getBody());
        if (config.getStorage() != null) {
            Timer.Context saveTimer = this.metricRegistry.timer(config.getStorage().getClass().getName()).time();
            URL url = config.getStorage().save(this.entry.getReferenceId(), fileName, fileExtension, mimeType, this.getReportFile());
            saveTimer.stop();
            msg = msg.replace("{url}", url.toString());
        }
        MimeBodyPart html = new MimeBodyPart();
        html.setContent((Object)msg, "text/html; charset=utf-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)html);
        if (config.getStorage() == null) {
            MimeBodyPart attachement = new MimeBodyPart();
            attachement.attachFile(this.getReportFile(), mimeType, null);
            attachement.setFileName(fileName + "." + fileExtension);
            multipart.addBodyPart((BodyPart)attachement);
        }
        message.setContent((Multipart)multipart);
        LOGGER.info("Emailing result to {}", (Object)to);
        Timer.Context timer = this.metricRegistry.timer(this.getClass().getName() + ".email").time();
        Transport.send((Message)message);
        timer.stop();
        stats.addEmailStats(recipients, config.getStorage() != null);
    }

    protected void deleteReport() {
        File reportFile = this.getReportFile();
        if (!reportFile.exists()) {
            return;
        }
        if (!reportFile.delete()) {
            LOGGER.warn("Failed deleting the temporary print report");
        }
    }

    private Session createEmailSession(final SmtpConfig config) {
        Session session;
        Properties prop = new Properties();
        prop.put("mail.smtp.starttls.enable", (Object)config.isStarttls());
        prop.put("mail.smtp.ssl.enable", (Object)config.isSsl());
        prop.put("mail.smtp.host", config.getHost());
        prop.put("mail.smtp.port", Integer.toString(config.getPort()));
        if (config.getUsername() != null) {
            prop.put("mail.smtp.auth", (Object)true);
            session = Session.getInstance((Properties)prop, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(config.getUsername(), config.getPassword());
                }
            });
        } else {
            session = Session.getInstance((Properties)prop);
        }
        return session;
    }

    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = SecurityContextHolder.createEmptyContext();
        this.securityContext.setAuthentication(securityContext.getAuthentication());
    }

    final void initForTesting(ApplicationContext context) {
        this.metricRegistry = (MetricRegistry)context.getBean(MetricRegistry.class);
        this.mapPrinterFactory = new MapPrinterFactory(){

            @Override
            public MapPrinter create(String app) {
                return null;
            }

            @Override
            public Set<String> getAppIds() {
                return null;
            }
        };
        this.entry = new PrintJobEntryImpl();
    }

    public static class PrintResult {
        public final long fileSize;
        @Nonnull
        public final Processor.ExecutionContext executionContext;

        public PrintResult(long fileSize, Processor.ExecutionContext executionContext) {
            this.fileSize = fileSize;
            this.executionContext = executionContext;
        }
    }

    protected static interface PrintAction {
        public Processor.ExecutionContext run(OutputStream var1) throws Exception;
    }
}

