/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.map.geotools.AbstractGridCoverageLayerPlugin;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.parser.HasDefaultValue;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class ImageLayer
extends AbstractSingleImageLayer {
    private final ImageParam params;
    private final StyleSupplier<GridCoverage2D> styleSupplier;
    private final ExecutorService executorService;
    private final Configuration configuration;

    protected ImageLayer(@Nonnull ExecutorService executorService, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull ImageParam params, @Nonnull Configuration configuration) {
        super(executorService, styleSupplier, params);
        this.params = params;
        this.styleSupplier = styleSupplier;
        this.executorService = executorService;
        this.configuration = configuration;
    }

    /*
     * Loose catch block
     */
    @Override
    protected BufferedImage loadImage(MfClientHttpRequestFactory requestFactory, MapfishMapContext transformer) throws Throwable {
        ImageParam layerParam = this.params;
        URI commonUri = new URI(layerParam.getBaseUrl());
        Double extentMinX = layerParam.extent[0];
        Double extentMinY = layerParam.extent[1];
        Double extentMaxX = layerParam.extent[2];
        Double extentMaxY = layerParam.extent[3];
        Rectangle paintArea = transformer.getPaintArea();
        ReferencedEnvelope envelope = transformer.getBounds().toReferencedEnvelope(paintArea);
        CoordinateReferenceSystem mapProjection = envelope.getCoordinateReferenceSystem();
        BufferedImage bufferedImage = new BufferedImage(paintArea.width, paintArea.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        MapBounds bounds = transformer.getBounds();
        MapContent content = new MapContent();
        ClientHttpRequest request = requestFactory.createRequest(commonUri, HttpMethod.GET);
        try {
            BufferedImage bufferedImage2;
            try (ClientHttpResponse httpResponse = request.execute();){
                BufferedImage image = ImageIO.read(httpResponse.getBody());
                if (image == null) {
                    BufferedImage bufferedImage3 = this.createErrorImage(paintArea);
                    return bufferedImage3;
                }
                GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
                GeneralEnvelope gridEnvelope = new GeneralEnvelope(mapProjection);
                gridEnvelope.setEnvelope(new double[]{extentMinX, extentMinY, extentMaxX, extentMaxY});
                GridCoverage2D coverage = factory.create((CharSequence)layerParam.getBaseUrl(), (RenderedImage)image, (Envelope)gridEnvelope, null, null, null);
                Style style = this.styleSupplier.load(requestFactory, coverage);
                GridCoverageLayer l = new GridCoverageLayer(coverage, style);
                content.addLayers(Collections.singletonList(l));
                StreamingRenderer renderer = new StreamingRenderer();
                RenderingHints hints = new RenderingHints(Collections.emptyMap());
                hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE));
                hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
                graphics.addRenderingHints(hints);
                renderer.setJava2DHints(hints);
                HashMap<String, Boolean> renderHints = new HashMap<String, Boolean>();
                if (transformer.isForceLongitudeFirst() != null) {
                    renderHints.put("ForceEPSGAxisOrder", transformer.isForceLongitudeFirst());
                }
                renderer.setRendererHints(renderHints);
                renderer.setMapContent(content);
                renderer.setThreadPool(this.executorService);
                ReferencedEnvelope mapArea = bounds.toReferencedEnvelope(paintArea);
                renderer.paint(graphics, paintArea, mapArea);
                bufferedImage2 = bufferedImage;
            }
            return bufferedImage2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            graphics.dispose();
            content.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createErrorImage(Rectangle area) {
        BufferedImage bufferedImage = new BufferedImage(area.width, area.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor(this.configuration.getTransparentTileErrorColor()));
            graphics.clearRect(0, 0, area.width, area.height);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.UNKNOWN;
    }

    public static final class ImageParam
    extends AbstractLayerParams {
        private static final int NUMBER_OF_EXTENT_COORDS = 4;
        public String baseURL;
        public double[] extent;
        @HasDefaultValue
        public String style = "raster";

        public void postConstruct() {
            Assert.equals((Object)4, (Object)this.extent.length, (String)("maxExtent must have exactly 4 elements to the array.  Was: " + Arrays.toString(this.extent)));
        }

        public String getBaseUrl() {
            return this.baseURL;
        }
    }

    public static final class ImageLayerPlugin
    extends AbstractGridCoverageLayerPlugin
    implements MapLayerFactoryPlugin<ImageParam> {
        private static final String TYPE = "image";
        @Autowired
        private ForkJoinPool forkJoinPool;

        @Override
        public Set<String> getTypeNames() {
            return Collections.singleton(TYPE);
        }

        @Override
        public ImageParam createParameter() {
            return new ImageParam();
        }

        @Nonnull
        public ImageLayer parse(@Nonnull Template template, @Nonnull ImageParam layerData) {
            String styleRef = layerData.style;
            return new ImageLayer(this.forkJoinPool, super.createStyleSupplier(template, styleRef), layerData, template.getConfiguration());
        }
    }
}

