/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.metrics;

import com.codahale.metrics.MetricRegistry;
import com.readytalk.metrics.StatsDReporter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StatsDReporterInit {
    private static final String ADDRESS = "STATSD_ADDRESS";
    private static final String PREFIX = "STATSD_PREFIX";
    private static final String PERIOD = "STATSD_PERIOD";
    private static final Logger LOGGER = LoggerFactory.getLogger(StatsDReporterInit.class);
    @Autowired
    private MetricRegistry metricRegistry;
    private StatsDReporter reporter = null;

    private static String getHostname() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null) {
            hostname = System.getenv("COMPUTERNAME");
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "unknown";
            }
        }
        return hostname.toLowerCase();
    }

    private String getConfig(String name, String def) {
        String result = System.getenv(name);
        if (result == null) {
            return System.getProperty(name, def);
        }
        return result;
    }

    @PostConstruct
    public final void init() throws URISyntaxException {
        String address = this.getConfig(ADDRESS, null);
        if (address != null) {
            URI uri = new URI("udp://" + address);
            String prefix = this.getConfig(PREFIX, "mapfish-print").replace("%h", StatsDReporterInit.getHostname());
            int period = Integer.parseInt(this.getConfig(PERIOD, "10"));
            LOGGER.info("Starting a StatsD reporter targeting {} with prefix {} and period {}s", new Object[]{uri, prefix, period});
            this.reporter = StatsDReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(prefix).build(uri.getHost(), uri.getPort());
            this.reporter.start((long)period, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public final void shutdown() {
        if (this.reporter != null) {
            LOGGER.info("Stopping the StatsD reporter");
            this.reporter.stop();
        }
    }
}

