/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

public final class URIUtils {
    private URIUtils() {
    }

    public static Multimap<String, String> getParameters(URI uri) {
        return URIUtils.getParameters(uri.getRawQuery());
    }

    public static Multimap<String, String> getParameters(String rawQuery) {
        HashMultimap result = HashMultimap.create();
        if (rawQuery == null) {
            return result;
        }
        StringTokenizer tokens = new StringTokenizer(rawQuery, "&");
        while (tokens.hasMoreTokens()) {
            String value;
            String key;
            String pair = tokens.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                key = pair;
                value = "";
            } else {
                try {
                    key = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
                    value = URLDecoder.decode(pair.substring(pos + 1), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
            result.put((Object)key, (Object)value);
        }
        return result;
    }

    public static String addParams(String url, Multimap<String, String> params, Set<String> overrideParams) throws URISyntaxException {
        return URIUtils.addParams(new URI(url), params, overrideParams).toString();
    }

    public static URI addParams(URI uri, Multimap<String, String> params, Set<String> overrideParams) {
        String key;
        if (params == null || params.isEmpty()) {
            return uri;
        }
        String origTxt = uri.toString();
        int queryStart = origTxt.indexOf(63);
        StringBuilder result = new StringBuilder();
        if (queryStart < 0) {
            int fragmentStart = origTxt.indexOf(35);
            if (fragmentStart < 0) {
                result.append(origTxt);
            } else {
                result.append(origTxt, 0, fragmentStart);
            }
        } else {
            result.append(origTxt, 0, queryStart);
        }
        Map origParams = URIUtils.getParameters(uri).asMap();
        boolean first = true;
        for (Map.Entry param : params.asMap().entrySet()) {
            key = (String)param.getKey();
            Collection origList = (Collection)origParams.remove(key);
            if (!(origList == null || overrideParams != null && overrideParams.contains(key))) {
                first = URIUtils.addParams(result, first, key, origList);
            }
            Collection list = (Collection)param.getValue();
            first = URIUtils.addParams(result, first, key, list);
        }
        for (Map.Entry param : origParams.entrySet()) {
            key = (String)param.getKey();
            Collection list = (Collection)param.getValue();
            first = URIUtils.addParams(result, first, key, list);
        }
        if (uri.getFragment() != null) {
            result.append('#').append(uri.getRawFragment());
        }
        try {
            return new URI(result.toString());
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    private static boolean addParams(StringBuilder result, boolean isFirstParam, String key, Collection<String> list) {
        boolean first = isFirstParam;
        for (String val : list) {
            if (first) {
                result.append('?');
                first = false;
            } else {
                result.append('&');
            }
            try {
                result.append(URLEncoder.encode(key, Constants.DEFAULT_ENCODING));
                result.append("=");
                result.append(URLEncoder.encode(val, Constants.DEFAULT_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }
        return first;
    }

    public static void addParamOverride(Multimap<String, String> params, String key, String value) {
        params.removeAll((Object)key);
        params.put((Object)key, (Object)value);
    }

    public static void setParamDefault(Multimap<String, String> params, String key, String value) {
        if (!params.containsKey((Object)key)) {
            params.put((Object)key, (Object)value);
        }
    }

    public static URI setQueryParams(URI initialUri, Multimap<String, String> queryParams) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : queryParams.entries()) {
            if (queryString.length() > 0) {
                queryString.append("&");
            }
            queryString.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        try {
            if (initialUri.getHost() == null && initialUri.getAuthority() != null) {
                return new URI(initialUri.getScheme(), initialUri.getAuthority(), initialUri.getPath(), queryString.toString(), initialUri.getFragment());
            }
            return new URI(initialUri.getScheme(), initialUri.getUserInfo(), initialUri.getHost(), initialUri.getPort(), initialUri.getPath(), queryString.toString(), initialUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    public static String toString(MfClientHttpRequestFactory requestFactory, URI uri) throws IOException {
        try (ClientHttpResponse response = requestFactory.createRequest(uri, HttpMethod.GET).execute();){
            String string = IOUtils.toString((InputStream)response.getBody(), (String)Constants.DEFAULT_ENCODING);
            return string;
        }
    }

    public static String toString(MfClientHttpRequestFactory requestFactory, URL url) throws IOException {
        try {
            return URIUtils.toString(requestFactory, url.toURI());
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    public static URI setPath(URI initialUri, String path) {
        String finalPath = path;
        if (!finalPath.startsWith("/")) {
            finalPath = '/' + path;
        }
        try {
            if (initialUri.getHost() == null && initialUri.getAuthority() != null) {
                return new URI(initialUri.getScheme(), initialUri.getAuthority(), finalPath, initialUri.getQuery(), initialUri.getFragment());
            }
            return new URI(initialUri.getScheme(), initialUri.getUserInfo(), initialUri.getHost(), initialUri.getPort(), finalPath, initialUri.getQuery(), initialUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }
}

