/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.processor.map.scalebar.HorizontalAlign;
import org.mapfish.print.processor.map.scalebar.Orientation;
import org.mapfish.print.processor.map.scalebar.Type;
import org.mapfish.print.processor.map.scalebar.VerticalAlign;

public class ScalebarAttribute
extends ReflectiveAttribute<ScalebarAttributeValues> {
    private Integer width = null;
    private Integer height = null;
    private Boolean createSubReport = true;

    @Override
    public final void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.width == null || this.width < 1) {
            validationErrors.add(new ConfigurationException("width field is not legal: " + this.width + " in " + this.getClass().getName()));
        }
        if (this.height == null || this.height < 1) {
            validationErrors.add(new ConfigurationException("height field is not legal: " + this.height + " in " + this.getClass().getName()));
        }
    }

    @Override
    public final ScalebarAttributeValues createValue(Template template) {
        return new ScalebarAttributeValues(new Dimension(this.width, this.height), this.createSubReport);
    }

    @Override
    public final Class<? extends ScalebarAttributeValues> getValueType() {
        return ScalebarAttributeValues.class;
    }

    public final Integer getWidth() {
        return this.width;
    }

    public final void setWidth(Integer width) {
        this.width = width;
    }

    public final Integer getHeight() {
        return this.height;
    }

    public final void setHeight(Integer height) {
        this.height = height;
    }

    public final Boolean getCreateSubReport() {
        return this.createSubReport;
    }

    public final void setCreateSubReport(Boolean createSubReport) {
        this.createSubReport = createSubReport;
    }

    public class ScalebarAttributeValues {
        private static final int DEFAULT_INTERVALS = 3;
        private static final String DEFAULT_FONT = "Helvetica";
        private static final int DEFAULT_FONT_SIZE = 12;
        private static final String DEFAULT_FONT_COLOR = "black";
        private static final String DEFAULT_COLOR = "black";
        private static final String DEFAULT_BAR_BG_COLOR = "white";
        private static final String DEFAULT_BACKGROUND_COLOR = "rgba(255, 255, 255, 0)";
        private final Dimension size;
        private final boolean createSubReport;
        @HasDefaultValue
        public String type = Type.BAR.getLabel();
        @HasDefaultValue
        public String unit = null;
        @HasDefaultValue
        public boolean geodetic = false;
        @HasDefaultValue
        public Boolean lockUnits = false;
        @HasDefaultValue
        public Integer intervals = 3;
        @HasDefaultValue
        public Boolean subIntervals = false;
        @HasDefaultValue
        public Integer barSize = null;
        @HasDefaultValue
        public Integer lineWidth = null;
        @HasDefaultValue
        public Integer labelDistance = null;
        @HasDefaultValue
        public Integer padding = null;
        @HasDefaultValue
        public String font = "Helvetica";
        @HasDefaultValue
        public Integer fontSize = 12;
        @HasDefaultValue
        public String fontColor = "black";
        @HasDefaultValue
        public String color = "black";
        @HasDefaultValue
        public String barBgColor = "white";
        @HasDefaultValue
        public String backgroundColor = "rgba(255, 255, 255, 0)";
        @HasDefaultValue
        public String orientation = Orientation.HORIZONTAL_LABELS_BELOW.getLabel();
        @HasDefaultValue
        public float labelRotation = 0.0f;
        @HasDefaultValue
        public String align = HorizontalAlign.LEFT.getLabel();
        @HasDefaultValue
        public String verticalAlign = VerticalAlign.BOTTOM.getLabel();
        @HasDefaultValue
        public Boolean renderAsSvg = true;

        public ScalebarAttributeValues(Dimension size, boolean createSubReport) {
            this.size = size;
            this.createSubReport = createSubReport;
        }

        public final void postConstruct() {
            if (this.getType() == null) {
                throw new IllegalArgumentException("invalid scalebar type: " + this.type);
            }
            if (this.unit != null && DistanceUnit.fromString(this.unit) == null) {
                throw new IllegalArgumentException("invalid unit: " + this.unit);
            }
            if (this.intervals < 1) {
                throw new IllegalArgumentException("invalid number of intervals: " + this.intervals);
            }
            if (this.color != null && !ColorParser.canParseColor(this.color)) {
                throw new IllegalArgumentException("invalid color: " + this.color);
            }
            if (this.fontColor != null && !ColorParser.canParseColor(this.fontColor)) {
                throw new IllegalArgumentException("invalid font color: " + this.fontColor);
            }
            if (this.barBgColor != null && !ColorParser.canParseColor(this.barBgColor)) {
                throw new IllegalArgumentException("invalid bar background color: " + this.barBgColor);
            }
            if (this.backgroundColor != null && !ColorParser.canParseColor(this.backgroundColor)) {
                throw new IllegalArgumentException("invalid background color: " + this.backgroundColor);
            }
            if (this.getOrientation() == null) {
                throw new IllegalArgumentException("invalid scalebar orientation: " + this.orientation);
            }
            if (this.getAlign() == null) {
                throw new IllegalArgumentException("invalid align: " + this.align);
            }
            if (this.getVerticalAlign() == null) {
                throw new IllegalArgumentException("invalid verticalAlign: " + this.verticalAlign);
            }
        }

        public final Dimension getSize() {
            return this.size;
        }

        public final Color getColor() {
            return ColorParser.toColor(this.color);
        }

        public final Color getFontColor() {
            return ColorParser.toColor(this.fontColor);
        }

        public final Color getBarBgColor() {
            return ColorParser.toColor(this.barBgColor);
        }

        public final Color getBackgroundColor() {
            return ColorParser.toColor(this.backgroundColor);
        }

        public final Type getType() {
            if (StringUtils.isEmpty((String)this.type)) {
                return null;
            }
            return Type.fromString(this.type);
        }

        public final DistanceUnit getUnit() {
            if (StringUtils.isEmpty((String)this.unit)) {
                return null;
            }
            return DistanceUnit.fromString(this.unit);
        }

        public final Orientation getOrientation() {
            if (StringUtils.isEmpty((String)this.orientation)) {
                return null;
            }
            return Orientation.fromString(this.orientation);
        }

        public final float getLabelRotation() {
            return (float)Math.toRadians(this.labelRotation);
        }

        public final HorizontalAlign getAlign() {
            if (StringUtils.isEmpty((String)this.align)) {
                return null;
            }
            return HorizontalAlign.fromString(this.align);
        }

        public final VerticalAlign getVerticalAlign() {
            if (StringUtils.isEmpty((String)this.verticalAlign)) {
                return null;
            }
            return VerticalAlign.fromString(this.verticalAlign);
        }

        public final boolean isCreateSubReport() {
            return this.createSubReport;
        }
    }
}

