/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.geotools.data.FeatureSource;
import org.geotools.styling.Style;
import org.locationtech.jts.geom.Geometry;
import org.mapfish.print.OptionalUtils;
import org.mapfish.print.SetsUtils;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.style.StyleParser;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFeatureSourceLayerPlugin<P>
implements MapLayerFactoryPlugin<P> {
    private final Set<String> typeNames;
    @Autowired
    protected StyleParser parser;
    @Autowired
    protected ExecutorService forkJoinPool;

    public AbstractFeatureSourceLayerPlugin(String typeName, String ... typeNames) {
        this.typeNames = SetsUtils.create(typeNames);
        this.typeNames.add(typeName);
    }

    @Override
    public final Set<String> getTypeNames() {
        return this.typeNames;
    }

    protected final StyleSupplier<FeatureSource> createStyleFunction(final Template template, final String styleString) {
        return new StyleSupplier<FeatureSource>(){

            @Override
            public Style load(MfClientHttpRequestFactory requestFactory, FeatureSource featureSource) {
                if (featureSource == null) {
                    throw new IllegalArgumentException("Feature source cannot be null");
                }
                String geomType = featureSource.getSchema() == null ? Geometry.class.getSimpleName().toLowerCase() : featureSource.getSchema().getGeometryDescriptor().getType().getBinding().getSimpleName();
                String styleRef = styleString != null ? styleString : geomType;
                StyleParser styleParser = AbstractFeatureSourceLayerPlugin.this.parser;
                return OptionalUtils.or(() -> template.getStyle(styleRef), () -> styleParser.loadStyle(template.getConfiguration(), requestFactory, styleRef)).orElseGet(() -> template.getConfiguration().getDefaultStyle(geomType));
            }
        };
    }

    public final void setParser(StyleParser parser) {
        this.parser = parser;
    }
}

