/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import org.apache.commons.io.IOUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.map.CreateMapProcessor;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;

public class MapExportOutputFormat
implements OutputFormat {
    private static final String MAP_SUBREPORT = "mapSubReport";
    @Autowired
    private ForkJoinPool forkJoinPool;
    @Autowired
    private MfClientHttpRequestFactoryImpl httpRequestFactory;
    private String fileSuffix;
    private String contentType;

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public final String getFileSuffix() {
        return this.fileSuffix;
    }

    public final void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    private String getMapSubReportVariable(Template template) {
        for (Processor processor : template.getProcessors()) {
            if (!(processor instanceof CreateMapProcessor)) continue;
            String mapSubReport = (String)((CreateMapProcessor)processor).getOutputMapperBiMap().get((Object)MAP_SUBREPORT);
            if (mapSubReport == null) {
                return MAP_SUBREPORT;
            }
            return mapSubReport;
        }
        return null;
    }

    @Override
    public final Processor.ExecutionContext print(String jobId, PJsonObject spec, Configuration config, File configDir, File taskDirectory, OutputStream outputStream) throws Exception {
        String templateName = spec.getString("layout");
        Template template = config.getTemplate(templateName);
        Values values = new Values(jobId, spec, template, taskDirectory, this.httpRequestFactory, null, this.fileSuffix);
        ProcessorDependencyGraph.ProcessorGraphForkJoinTask task = template.getProcessorGraph().createTask(values);
        ForkJoinTask<Values> taskFuture = this.forkJoinPool.submit(task);
        try {
            taskFuture.get();
        }
        catch (InterruptedException exc) {
            taskFuture.cancel(true);
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
        String mapSubReport = values.getString(this.getMapSubReportVariable(template));
        try {
            mapSubReport = new File(new URI(mapSubReport)).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        try (FileInputStream is = new FileInputStream(mapSubReport);){
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        }
        return task.getExecutionContext();
    }
}

