/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.RegexpUtil;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.AbstractMfClientHttpRequestFactoryWrapper;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.http.AbstractClientHttpRequestFactoryProcessor;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class UseHttpForHttpsProcessor
extends AbstractClientHttpRequestFactoryProcessor {
    private static final int HTTPS_STANDARD_PORT = 443;
    private static final int HTTP_STANDARD_PORT = 80;
    private static final int JAVA_HTTPS_STANDARD_PORT = 8443;
    private static final int JAVA_HTTP_STANDARD_PORT = 8080;
    private static final Pattern HTTP_AUTHORITY_PORT_EXTRACTOR = Pattern.compile("(.*@)?.*:(\\d+)");
    private static final Pattern HTTP_AUTHORITY_HOST_EXTRACTOR = Pattern.compile("(.*@)?([^:]*)(:\\d+)?");
    private Map<Integer, Integer> portMapping = new HashMap<Integer, Integer>();
    private List<Pattern> hosts = new ArrayList<Pattern>();

    protected UseHttpForHttpsProcessor() {
        this.portMapping.put(443, 80);
        this.portMapping.put(8443, 8080);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        super.extraValidation(validationErrors, configuration);
        if (this.hosts.isEmpty()) {
            validationErrors.add(new IllegalArgumentException("No hosts are registered"));
        }
    }

    @Override
    public MfClientHttpRequestFactory createFactoryWrapper(ClientHttpFactoryProcessorParam clientHttpFactoryProcessorParam, MfClientHttpRequestFactory requestFactory) {
        return new AbstractMfClientHttpRequestFactoryWrapper(requestFactory, this.matchers, false){

            @Override
            protected ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod, MfClientHttpRequestFactory requestFactory) throws IOException {
                if (uri.getScheme() != null && uri.getScheme().equals("https")) {
                    try {
                        URI httpUri = uri;
                        if (uri.getHost() == null && uri.getAuthority() != null) {
                            String host;
                            Matcher matcher = HTTP_AUTHORITY_HOST_EXTRACTOR.matcher(uri.getAuthority());
                            if (matcher.matches() && UseHttpForHttpsProcessor.this.matchingHost(host = matcher.group(2))) {
                                httpUri = UseHttpForHttpsProcessor.this.updatePortAndSchemeInAuthority(uri);
                            }
                        } else if (UseHttpForHttpsProcessor.this.matchingHost(uri.getHost())) {
                            httpUri = UseHttpForHttpsProcessor.this.updatePortAndScheme(uri);
                        }
                        return requestFactory.createRequest(httpUri, httpMethod);
                    }
                    catch (URISyntaxException e) {
                        throw ExceptionUtils.getRuntimeException(e);
                    }
                }
                return requestFactory.createRequest(uri, httpMethod);
            }
        };
    }

    public void setPortMapping(Map<Integer, Integer> portMapping) {
        this.portMapping.putAll(portMapping);
    }

    public void setHosts(List<String> hosts) {
        this.hosts.clear();
        for (String host : hosts) {
            this.hosts.add(RegexpUtil.compilePattern(host));
        }
    }

    private boolean matchingHost(String host) {
        for (Pattern hostPattern : this.hosts) {
            if (!hostPattern.matcher(host).matches()) continue;
            return true;
        }
        return false;
    }

    private URI updatePortAndScheme(URI uri) throws URISyntaxException {
        int port = uri.getPort();
        if (this.portMapping.containsKey(port)) {
            port = this.portMapping.get(port);
        }
        URI httpUri = new URI("http", uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        return httpUri;
    }

    private URI updatePortAndSchemeInAuthority(URI uri) throws URISyntaxException {
        String authority = uri.getAuthority();
        Matcher matcher = HTTP_AUTHORITY_PORT_EXTRACTOR.matcher(uri.getAuthority());
        if (matcher.matches()) {
            int port = Integer.parseInt(matcher.group(2));
            authority = authority.substring(0, matcher.start(2));
            if (this.portMapping.containsKey(port)) {
                port = this.portMapping.get(port);
            }
            authority = authority + port;
        }
        URI httpUri = new URI("http", authority, uri.getPath(), uri.getQuery(), uri.getFragment());
        return httpUri;
    }
}

