/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractGeotoolsLayer;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.processor.Processor;
import org.opengis.geometry.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractSingleImageLayer
extends AbstractGeotoolsLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSingleImageLayer.class);
    @Nonnull
    protected final MetricRegistry registry;
    protected final Configuration configuration;
    private final StyleSupplier<GridCoverage2D> styleSupplier;

    protected AbstractSingleImageLayer(ExecutorService executorService, StyleSupplier<GridCoverage2D> styleSupplier, AbstractLayerParams params, MetricRegistry registry, Configuration configuration) {
        super(executorService, params);
        this.styleSupplier = styleSupplier;
        this.registry = registry;
        this.configuration = configuration;
    }

    @Override
    protected final List<? extends Layer> getLayers(MfClientHttpRequestFactory httpRequestFactory, MapfishMapContext mapContext, Processor.ExecutionContext context) {
        BufferedImage image;
        try {
            image = this.loadImage(httpRequestFactory, mapContext);
        }
        catch (Throwable t) {
            throw ExceptionUtils.getRuntimeException(t);
        }
        MapBounds bounds = mapContext.getBounds();
        ReferencedEnvelope mapEnvelope = bounds.toReferencedEnvelope(mapContext.getPaintArea());
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GeneralEnvelope gridEnvelope = new GeneralEnvelope(mapEnvelope.getCoordinateReferenceSystem());
        gridEnvelope.setEnvelope(new double[]{mapEnvelope.getMinX(), mapEnvelope.getMinY(), mapEnvelope.getMaxX(), mapEnvelope.getMaxY()});
        String coverageName = this.getClass().getSimpleName();
        GridCoverage2D gridCoverage2D = factory.create((CharSequence)coverageName, (RenderedImage)image, (Envelope)gridEnvelope, null, null, null);
        Style style = this.styleSupplier.load(httpRequestFactory, gridCoverage2D);
        return Collections.singletonList(new GridCoverageLayer(gridCoverage2D, style));
    }

    protected abstract BufferedImage loadImage(MfClientHttpRequestFactory var1, MapfishMapContext var2) throws Throwable;

    @Override
    public final double getImageBufferScaling() {
        return 1.0;
    }

    public StyleSupplier<GridCoverage2D> getStyleSupplier() {
        return this.styleSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createErrorImage(Rectangle area) {
        BufferedImage bufferedImage = new BufferedImage(area.width, area.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor(this.configuration.getTransparentTileErrorColor()));
            graphics.clearRect(0, 0, area.width, area.height);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BufferedImage fetchImage(@Nonnull ClientHttpRequest request, @Nonnull MapfishMapContext transformer) throws IOException {
        String baseMetricName = this.getClass().getName() + ".read." + request.getURI().getHost();
        Timer.Context timerDownload = this.registry.timer(baseMetricName).time();
        try (ClientHttpResponse httpResponse = request.execute();){
            if (httpResponse.getStatusCode() != HttpStatus.OK) {
                String message = String.format("Invalid status code for %s (%d!=%d). The response was: '%s'", request.getURI(), httpResponse.getStatusCode().value(), HttpStatus.OK.value(), httpResponse.getStatusText());
                this.registry.counter(baseMetricName + ".error").inc();
                if (this.getFailOnError()) {
                    throw new RuntimeException(message);
                }
                LOGGER.info(message);
                BufferedImage bufferedImage = this.createErrorImage(transformer.getPaintArea());
                return bufferedImage;
            }
            List contentType = httpResponse.getHeaders().get((Object)"Content-Type");
            if (contentType == null || contentType.size() != 1) {
                LOGGER.debug("The image {} didn't return a valid content type header.", (Object)request.getURI());
            } else if (!((String)contentType.get(0)).startsWith("image/")) {
                byte[] data;
                try (InputStream body = httpResponse.getBody();){
                    data = IOUtils.toByteArray((InputStream)body);
                }
                LOGGER.debug("We get a wrong image for {}, content type: {}\nresult:\n{}", new Object[]{request.getURI(), contentType.get(0), new String(data, StandardCharsets.UTF_8)});
                this.registry.counter(baseMetricName + ".error").inc();
                BufferedImage bufferedImage = this.createErrorImage(transformer.getPaintArea());
                return bufferedImage;
            }
            BufferedImage image = ImageIO.read(httpResponse.getBody());
            if (image == null) {
                LOGGER.warn("Cannot read image from %a", (Object)request.getURI());
                this.registry.counter(baseMetricName + ".error").inc();
                if (this.getFailOnError()) {
                    throw new RuntimeException("Cannot read image from " + request.getURI());
                }
                BufferedImage bufferedImage = this.createErrorImage(transformer.getPaintArea());
                return bufferedImage;
            }
            timerDownload.stop();
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Throwable e) {
            this.registry.counter(baseMetricName + ".error").inc();
            throw e;
        }
    }
}

