/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.parser;

import com.google.common.collect.Collections2;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.parser.CanSatisfyOneOf;
import org.mapfish.print.parser.OneOf;

final class OneOfTracker {
    private Map<String, OneOfGroup> mapping = new HashMap<String, OneOfGroup>();

    OneOfTracker() {
    }

    public void register(Field field) {
        OneOf oneOfAnnotation = field.getAnnotation(OneOf.class);
        String groupName = null;
        if (oneOfAnnotation != null) {
            groupName = oneOfAnnotation.value();
        } else {
            CanSatisfyOneOf canSatisfyOneOf = field.getAnnotation(CanSatisfyOneOf.class);
            if (canSatisfyOneOf != null) {
                groupName = canSatisfyOneOf.value();
            }
        }
        if (groupName != null) {
            OneOfGroup oneOfGroup = this.mapping.get(groupName);
            if (oneOfGroup == null) {
                oneOfGroup = new OneOfGroup(groupName);
                this.mapping.put(groupName, oneOfGroup);
            }
            oneOfGroup.choices.add(field);
        }
    }

    public void markAsVisited(Field field) {
        CanSatisfyOneOf canSatisfyOneOf;
        OneOf oneOfAnnotation = field.getAnnotation(OneOf.class);
        if (oneOfAnnotation != null) {
            OneOfGroup oneOfGroup = this.mapping.get(oneOfAnnotation.value());
            oneOfGroup.satisfiedBy.add(new OneOfSatisfier(field, false));
        }
        if ((canSatisfyOneOf = field.getAnnotation(CanSatisfyOneOf.class)) != null) {
            OneOfGroup oneOfGroup = this.mapping.get(canSatisfyOneOf.value());
            oneOfGroup.satisfiedBy.add(new OneOfSatisfier(field, true));
        }
    }

    public void checkAllGroupsSatisfied(String currentPath) {
        StringBuilder errors = new StringBuilder();
        for (OneOfGroup group : this.mapping.values()) {
            Collection oneOfSatisfiers;
            if (group.satisfiedBy.isEmpty()) {
                errors.append("\n");
                errors.append("\t* The OneOf choice: ").append(group.name).append(" was not satisfied.  One (and only one) of the ");
                errors.append("following fields is required in the request data: ").append(this.toNames(group.choices));
            }
            if ((oneOfSatisfiers = Collections2.filter((Collection)group.satisfiedBy, input -> !((OneOfSatisfier)input).isCanSatisfy)).size() <= 1) continue;
            errors.append("\n");
            errors.append("\t* The OneOf choice: ").append(group.name).append(" was satisfied by too many fields.  Only one choice ");
            errors.append("may be in the request data.  The fields found were: ").append(this.toNames(this.toFields(group.satisfiedBy)));
        }
        Assert.equals((Object)0, (Object)errors.length(), (String)("\nErrors were detected when analysing the @OneOf dependencies of '" + currentPath + "': \n" + errors));
    }

    private Collection<Field> toFields(Set<OneOfSatisfier> satisfiedBy) {
        return Collections2.transform(satisfiedBy, input -> ((OneOfSatisfier)input).field);
    }

    private String toNames(Collection<Field> choices) {
        StringBuilder names = new StringBuilder();
        for (Field choice : choices) {
            if (names.length() > 0) {
                names.append(", ");
            }
            String type = choice.getType().getName();
            if (choice.getType().isArray()) {
                type = choice.getType().getComponentType().getName() + "[]";
            }
            names.append(type).append(' ').append(choice.getName());
        }
        return names.toString();
    }

    private static final class OneOfSatisfier {
        private final Field field;
        private final boolean isCanSatisfy;

        private OneOfSatisfier(@Nonnull Field field, boolean isCanSatisfy) {
            this.field = field;
            this.isCanSatisfy = isCanSatisfy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OneOfSatisfier that = (OneOfSatisfier)o;
            return this.field.equals(that.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }
    }

    private static final class OneOfGroup {
        private String name;
        private Collection<Field> choices = new ArrayList<Field>();
        private Set<OneOfSatisfier> satisfiedBy = new HashSet<OneOfSatisfier>();

        private OneOfGroup(String name) {
            this.name = name;
        }
    }
}

