/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.mapfish.print.ExceptionUtils;
import org.opengis.referencing.cs.AxisDirection;

public final class LinearCoordinateSequence
implements CoordinateSequence,
Cloneable {
    private int dimension;
    private double axis0Origin;
    private double axis1Origin;
    private int variableAxis;
    private int numPoints;
    private double spacing;
    private AxisDirection ordinate0AxisDirection;

    public LinearCoordinateSequence setOrigin(double axis1Origin, double axis2Origin) {
        this.axis0Origin = axis1Origin;
        this.axis1Origin = axis2Origin;
        return this;
    }

    public LinearCoordinateSequence setVariableAxis(int variableAxis) {
        this.variableAxis = variableAxis;
        return this;
    }

    public LinearCoordinateSequence setNumPoints(int numPoints) {
        this.numPoints = numPoints;
        return this;
    }

    public LinearCoordinateSequence setSpacing(double spacing) {
        this.spacing = spacing;
        return this;
    }

    public LinearCoordinateSequence setOrdinate0AxisDirection(AxisDirection ordinate0AxisDirection) {
        this.ordinate0AxisDirection = ordinate0AxisDirection;
        return this;
    }

    public int getDimension() {
        return this.dimension;
    }

    public LinearCoordinateSequence setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    public Coordinate getCoordinate(int i) {
        Coordinate coord = new Coordinate();
        this.getCoordinate(i, coord);
        return coord;
    }

    public Coordinate getCoordinateCopy(int i) {
        Coordinate coord = new Coordinate();
        this.getCoordinate(i, coord);
        return coord;
    }

    public void getCoordinate(int index, Coordinate coord) {
        Coordinate finalCoord = coord;
        if (coord == null) {
            finalCoord = new Coordinate();
        }
        for (int i = 0; i < this.dimension; ++i) {
            finalCoord.setOrdinate(i, this.getOrdinate(index, i));
        }
    }

    public double getX(int index) {
        if (this.ordinate0IsY()) {
            return this.getOrdinate(0, 1);
        }
        return this.getOrdinate(0, 0);
    }

    public double getY(int index) {
        if (this.ordinate0IsY()) {
            return this.getOrdinate(0, 0);
        }
        return this.getOrdinate(0, 1);
    }

    public double getOrdinate(int index, int ordinateIndex) {
        double ordinate;
        if (ordinateIndex == 0) {
            ordinate = this.axis0Origin;
        } else if (ordinateIndex == 1) {
            ordinate = this.axis1Origin;
        } else {
            return 0.0;
        }
        if (this.variableAxis == ordinateIndex) {
            ordinate += this.spacing * (double)index;
        }
        return ordinate;
    }

    public int size() {
        return this.numPoints;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        throw new UnsupportedOperationException("This coordinate sequence implementation is read only");
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coordinates = new Coordinate[this.numPoints];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = this.getCoordinate(i);
        }
        return coordinates;
    }

    public Envelope expandEnvelope(Envelope env) {
        Envelope envelope = env;
        if (envelope == null) {
            envelope = new Envelope();
        }
        for (int i = 0; i < this.numPoints; ++i) {
            envelope.expandToInclude(this.getOrdinate(i, 0), this.getOrdinate(i, 1));
        }
        return envelope;
    }

    private boolean ordinate0IsY() {
        return this.ordinate0AxisDirection == AxisDirection.DOWN || this.ordinate0AxisDirection == AxisDirection.UP || this.ordinate0AxisDirection == AxisDirection.NORTH || this.ordinate0AxisDirection == AxisDirection.SOUTH || this.ordinate0AxisDirection == AxisDirection.DISPLAY_DOWN || this.ordinate0AxisDirection == AxisDirection.DISPLAY_UP;
    }

    public Object clone() {
        return this.copy();
    }

    public CoordinateSequence copy() {
        try {
            LinearCoordinateSequence clone = (LinearCoordinateSequence)super.clone();
            clone.numPoints = this.numPoints;
            clone.axis0Origin = this.axis0Origin;
            clone.axis1Origin = this.axis1Origin;
            clone.variableAxis = this.variableAxis;
            clone.dimension = this.dimension;
            clone.ordinate0AxisDirection = this.ordinate0AxisDirection;
            clone.spacing = this.spacing;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }
}

