/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.BiMap;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.HttpRequestHeadersAttribute;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.config.Template;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.CustomDependencies;
import org.mapfish.print.processor.InputOutputValue;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorGraphNode;
import org.mapfish.print.processor.ProcessorUtils;
import org.mapfish.print.processor.ProvideAttributes;
import org.mapfish.print.processor.RequireAttributes;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.springframework.beans.factory.annotation.Autowired;

public final class ProcessorDependencyGraphFactory {
    @Autowired
    private MetricRegistry metricRegistry;

    private static Set<InputValue> getInputs(Processor<?, ?> processor) {
        BiMap<String, String> inputMapper = processor.getInputMapperBiMap();
        HashSet<InputValue> inputs = new HashSet<InputValue>();
        Object inputParameter = processor.createInputParameter();
        if (inputParameter != null) {
            ProcessorDependencyGraphFactory.verifyAllMappingsMatchParameter(inputMapper.values(), inputParameter.getClass(), "One or more of the input mapping values of '" + processor + "'  do not match an input parameter.  The bad mappings are");
            Collection<Field> allProperties = ParserUtils.getAllAttributes(inputParameter.getClass());
            for (Field field : allProperties) {
                String name = ProcessorUtils.getInputValueName(processor.getInputPrefix(), inputMapper, field.getName());
                inputs.add(new InputValue(name, field));
            }
        }
        return inputs;
    }

    private static Collection<OutputValue> getOutputValues(Processor<?, ?> processor) {
        BiMap<String, String> outputMapper = processor.getOutputMapperBiMap();
        HashSet<OutputValue> values = new HashSet<OutputValue>();
        Set<String> mappings = outputMapper.keySet();
        Class<?> paramType = processor.getOutputType();
        ProcessorDependencyGraphFactory.verifyAllMappingsMatchParameter(mappings, paramType, "One or more of the output mapping keys of '" + processor + "' do not match an output parameter.  The bad mappings are: ");
        Collection<Field> allProperties = ParserUtils.getAllAttributes(paramType);
        for (Field field : allProperties) {
            boolean canBeRenamed = field.getAnnotation(InternalValue.class) != null;
            String name = ProcessorUtils.getOutputValueName(processor.getOutputPrefix(), outputMapper, field);
            values.add(new OutputValue(name, canBeRenamed, field));
        }
        return values;
    }

    public static void fillProcessorAttributes(List<Processor> processors, Map<String, Attribute> initialAttributes) {
        HashMap<String, Attribute> currentAttributes = new HashMap<String, Attribute>(initialAttributes);
        for (Processor processor : processors) {
            if (processor instanceof RequireAttributes) {
                for (InputValue inputValue : ProcessorDependencyGraphFactory.getInputs(processor)) {
                    if (inputValue.type == Values.class) {
                        if (processor instanceof CustomDependencies) {
                            for (String string : ((CustomDependencies)((Object)processor)).getDependencies()) {
                                Attribute attribute = (Attribute)currentAttributes.get(string);
                                if (attribute == null) continue;
                                ((RequireAttributes)((Object)processor)).setAttribute(string, (Attribute)currentAttributes.get(string));
                            }
                            continue;
                        }
                        for (Map.Entry entry : currentAttributes.entrySet()) {
                            ((RequireAttributes)((Object)processor)).setAttribute((String)entry.getKey(), (Attribute)entry.getValue());
                        }
                        continue;
                    }
                    try {
                        ((RequireAttributes)((Object)processor)).setAttribute(inputValue.internalName, (Attribute)currentAttributes.get(inputValue.name));
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException(String.format("The processor '%s' requires the attribute '%s' (%s) but he has the wrong type:\n%s", processor, inputValue.name, inputValue.internalName, e.getMessage()), e);
                    }
                }
            }
            if (!(processor instanceof ProvideAttributes)) continue;
            Map<String, Attribute> newAttributes = ((ProvideAttributes)((Object)processor)).getAttributes();
            for (OutputValue ouputValue : ProcessorDependencyGraphFactory.getOutputValues(processor)) {
                currentAttributes.put(ouputValue.name, newAttributes.get(ouputValue.internalName));
            }
        }
    }

    private static void verifyAllMappingsMatchParameter(Set<String> mappings, Class<?> paramType, String errorMessagePrefix) {
        Set<String> attributeNames = ParserUtils.getAllAttributeNames(paramType);
        StringBuilder errors = new StringBuilder();
        for (String mapping : mappings) {
            if (attributeNames.contains(mapping)) continue;
            errors.append("\n  * ").append(mapping);
        }
        Assert.isTrue((0 == errors.length() ? 1 : 0) != 0, (String)(errorMessagePrefix + errors + ProcessorDependencyGraphFactory.listOptions(attributeNames) + "\n"));
    }

    private static String listOptions(Set<String> attributeNames) {
        StringBuilder msg = new StringBuilder("\n\nThe possible parameter names are:");
        for (String attributeName : attributeNames) {
            msg.append("\n  * ").append(attributeName);
        }
        return msg.toString();
    }

    public ProcessorDependencyGraph build(List<? extends Processor> processors, Map<String, Class<?>> attributes) {
        ProcessorDependencyGraph graph = new ProcessorDependencyGraph();
        HashMap provideByProcessor = new HashMap();
        HashMap outputTypes = new HashMap(attributes);
        outputTypes.put("values", Values.class);
        outputTypes.put("tempTaskDirectory", File.class);
        outputTypes.put("clientHttpRequestFactoryProvider", MfClientHttpRequestFactoryProvider.class);
        outputTypes.put("template", Template.class);
        outputTypes.put("pdfConfig", PDFConfig.class);
        outputTypes.put("SUBREPORT_DIR", String.class);
        outputTypes.put("outputFormat", String.class);
        outputTypes.put("jobId", String.class);
        outputTypes.put("requestHeaders", HttpRequestHeadersAttribute.Value.class);
        outputTypes.put("REPORT_LOCALE", Locale.class);
        for (Processor processor : processors) {
            ProcessorGraphNode node = new ProcessorGraphNode(processor, this.metricRegistry);
            Set<InputValue> inputs = ProcessorDependencyGraphFactory.getInputs(node.getProcessor());
            boolean isRoot = true;
            for (InputValue input : inputs) {
                if (input.name.equals("values")) {
                    if (processor instanceof CustomDependencies) {
                        for (String name : ((CustomDependencies)((Object)processor)).getDependencies()) {
                            Class outputType = (Class)outputTypes.get(name);
                            if (outputType == null) {
                                throw new IllegalArgumentException(String.format("The Processor '%s' has no value for the dynamic input '%s'.", processor, name));
                            }
                            ProcessorGraphNode processorSolution = (ProcessorGraphNode)provideByProcessor.get(name);
                            if (processorSolution == null) continue;
                            processorSolution.addDependency(node);
                            isRoot = false;
                        }
                        continue;
                    }
                    for (ProcessorGraphNode processorSolution : provideByProcessor.values()) {
                        processorSolution.addDependency(node);
                        isRoot = false;
                    }
                    continue;
                }
                Class outputType = (Class)outputTypes.get(input.name);
                if (outputType != null) {
                    Class<?> inputType = input.type;
                    ProcessorGraphNode processorSolution = (ProcessorGraphNode)provideByProcessor.get(input.name);
                    if (inputType.isAssignableFrom(outputType)) {
                        if (processorSolution == null) continue;
                        processorSolution.addDependency(node);
                        isRoot = false;
                        continue;
                    }
                    if (processorSolution != null) {
                        throw new IllegalArgumentException(String.format("Type conflict: Processor '%s' provides an output with name '%s' and of type '%s', while processor '%s' expects an input of that name with type '%s'! Please rename one of the attributes in the mappings of the processors.", processorSolution.getName(), input.name, outputType, node.getName(), inputType));
                    }
                    throw new IllegalArgumentException(String.format("Type conflict: the attribute '%s' of type '%s', while processor '%s' expects an input of that name with type '%s'!", input.name, outputType, node.getName(), inputType));
                }
                if (input.field.getAnnotation(HasDefaultValue.class) != null) continue;
                throw new IllegalArgumentException(String.format("The Processor '%s' has no value for the input '%s'.", processor, input.name));
            }
            if (isRoot) {
                graph.addRoot(node);
            }
            for (OutputValue value : ProcessorDependencyGraphFactory.getOutputValues(node.getProcessor())) {
                String outputName = value.name;
                if (outputTypes.containsKey(outputName)) {
                    if (value.canBeRenamed) {
                        outputName = outputName + "_" + UUID.randomUUID().toString();
                    } else {
                        ProcessorGraphNode provider = (ProcessorGraphNode)provideByProcessor.get(outputName);
                        if (provider == null) {
                            throw new IllegalArgumentException(String.format("Processors '%s' provide the output '%s' who is already declared as an attribute.  You have to rename one of the outputs and the corresponding input so that there is no ambiguity with regards to the input a processor consumes.", processor, outputName));
                        }
                        throw new IllegalArgumentException(String.format("Multiple processors provide the same output mapping: '%s' and '%s' both provide: '%s'.  You have to rename one of the outputs and the corresponding input so that there is no ambiguity with regards to the input a processor consumes.", processor, provider, outputName));
                    }
                }
                provideByProcessor.put(outputName, node);
                outputTypes.put(outputName, value.type);
            }
            for (InputValue input : inputs) {
                if (input.field.getAnnotation(InputOutputValue.class) == null) continue;
                provideByProcessor.put(input.name, node);
            }
        }
        Collection missingProcessors = CollectionUtils.subtract(processors, graph.getAllProcessors());
        StringBuilder stringBuilder = new StringBuilder();
        for (Processor p : missingProcessors) {
            stringBuilder.append("\n- ");
            stringBuilder.append(p.toString());
        }
        Assert.isTrue((boolean)missingProcessors.isEmpty(), (String)("The processor graph:\n" + graph + "\ndoes not contain all the processors, missing:" + stringBuilder));
        return graph;
    }

    private static final class OutputValue
    extends InputValue {
        public final boolean canBeRenamed;

        private OutputValue(String name, boolean canBeRenamed, Field field) {
            super(name, field);
            this.canBeRenamed = canBeRenamed;
        }
    }

    private static class InputValue {
        public final String name;
        public final String internalName;
        public final Class<?> type;
        public final Field field;

        private InputValue(String name, Field field) {
            this.name = name;
            this.internalName = field.getName();
            this.type = field.getType();
            this.field = field;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            InputValue that = (InputValue)obj;
            return Objects.equals(this.name, that.name);
        }

        public String toString() {
            return "InputValue{name='" + this.name + "', type=" + this.type.getSimpleName() + '}';
        }
    }
}

