/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ServletMapPrinterFactory
implements MapPrinterFactory {
    public static final String DEFAULT_CONFIGURATION_FILE_KEY = "default";
    private static final String CONFIG_YAML = "config.yaml";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletMapPrinterFactory.class);
    private static final int MAX_DEPTH = 2;
    private final Map<String, MapPrinter> printers = new HashMap<String, MapPrinter>();
    private final Map<String, Long> configurationFileLastModifiedTimes = new HashMap<String, Long>();
    private final Map<String, URI> configurationFiles = new HashMap<String, URI>();
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ConfigFileLoaderManager configFileLoader;
    private String appsRootDirectory = null;

    @PostConstruct
    private void validateConfigurationFiles() {
        for (URI file : this.configurationFiles.values()) {
            Assert.isTrue((boolean)this.configFileLoader.isAccessible(file), (String)(file + " does not exist or is not accessible."));
        }
    }

    @Override
    public final synchronized MapPrinter create(@Nullable String app) throws NoSuchAppException {
        Optional<Long> configFileLastModified;
        URI configFile;
        String finalApp = app;
        if (app == null) {
            finalApp = DEFAULT_CONFIGURATION_FILE_KEY;
        }
        if ((configFile = this.configurationFiles.get(finalApp)) == null) {
            configFile = this.checkForAddedApp(finalApp);
        }
        if (configFile == null) {
            throw new NoSuchAppException("There is no configurationFile registered in the " + this.getClass().getName() + " bean with the id: '" + finalApp + "'");
        }
        long lastModified = this.configurationFileLastModifiedTimes.getOrDefault(finalApp, 0L);
        MapPrinter printer = this.printers.get(finalApp);
        try {
            configFileLastModified = this.configFileLoader.lastModified(configFile);
        }
        catch (NoSuchElementException e) {
            this.configurationFiles.remove(finalApp);
            this.configurationFileLastModifiedTimes.remove(finalApp);
            this.printers.remove(finalApp);
            if (finalApp.equals(DEFAULT_CONFIGURATION_FILE_KEY)) {
                this.pickDefaultApp();
            }
            throw new NoSuchAppException("There is no configurationFile registered in the " + this.getClass().getName() + " bean with the id: '" + finalApp + "'");
        }
        if (configFileLastModified.isPresent() && configFileLastModified.get() > lastModified) {
            LOGGER.info("Configuration file modified. Reloading...");
            this.printers.remove(finalApp);
            printer = null;
        }
        if (printer == null) {
            if (configFileLastModified.isPresent()) {
                this.configurationFileLastModifiedTimes.put(finalApp, configFileLastModified.get());
            }
            try {
                LOGGER.info("Loading configuration file: {}", (Object)configFile);
                printer = (MapPrinter)this.applicationContext.getBean(MapPrinter.class);
                byte[] bytes = this.configFileLoader.loadFile(configFile);
                printer.setConfiguration(configFile, bytes);
                this.printers.put(finalApp, printer);
            }
            catch (ClosedByInterruptException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Error occurred while reading configuration file '{}'", (Object)configFile);
                throw new RuntimeException(String.format("Error occurred while reading configuration file '%s': ", configFile), e);
            }
            catch (Throwable e) {
                LOGGER.error("Error occurred while reading configuration file '{}'", (Object)configFile);
                throw new RuntimeException(String.format("Error occurred while reading configuration file '%s'", configFile), e);
            }
        }
        return printer;
    }

    @Override
    public final Set<String> getAppIds() {
        return this.configurationFiles.keySet();
    }

    public final void setConfigurationFiles(Map<String, String> configurationFiles) throws URISyntaxException {
        this.configurationFiles.clear();
        this.configurationFileLastModifiedTimes.clear();
        for (Map.Entry<String, String> entry : configurationFiles.entrySet()) {
            if (!entry.getValue().contains(":/")) {
                this.configurationFiles.put(entry.getKey(), new File(entry.getValue()).toURI());
                continue;
            }
            this.configurationFiles.put(entry.getKey(), new URI(entry.getValue()));
        }
        if (this.configFileLoader != null) {
            this.validateConfigurationFiles();
        }
    }

    public final void setAppsRootDirectory(String directory) throws URISyntaxException, IOException {
        File realRoot;
        this.appsRootDirectory = directory;
        if (!directory.contains(":/")) {
            realRoot = new File(directory);
        } else {
            Optional<File> fileOptional = this.configFileLoader.toFile(new URI(directory));
            if (fileOptional.isPresent()) {
                realRoot = fileOptional.get();
            } else {
                throw new IllegalArgumentException(directory + " does not refer to a file on the current system.");
            }
        }
        AppWalker walker = new AppWalker();
        for (File child : walker.getAppDirs(realRoot)) {
            File configFile = new File(child, CONFIG_YAML);
            String appName = realRoot.toURI().relativize(child.toURI()).getPath().replace('/', ':');
            if (appName.endsWith(":")) {
                appName = appName.substring(0, appName.length() - 1);
            }
            this.configurationFiles.put(appName, configFile.toURI());
        }
        if (this.configurationFiles.isEmpty()) {
            return;
        }
        if (!this.configurationFiles.containsKey(DEFAULT_CONFIGURATION_FILE_KEY)) {
            this.pickDefaultApp();
        }
    }

    private void pickDefaultApp() {
        Iterator<Map.Entry<String, URI>> iterator = this.configurationFiles.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, URI> next = iterator.next();
            URI uri = next.getValue();
            this.configurationFiles.put(DEFAULT_CONFIGURATION_FILE_KEY, uri);
        }
    }

    @Nullable
    private URI checkForAddedApp(@Nonnull String app) {
        File configFile;
        Optional<File> child;
        if (this.appsRootDirectory == null) {
            return null;
        }
        if (StringUtils.countMatches((CharSequence)app, (CharSequence)":") > 2) {
            return null;
        }
        try {
            child = this.configFileLoader.toFile(new URI(this.appsRootDirectory + "/" + app.replace(':', '/')));
        }
        catch (URISyntaxException e) {
            return null;
        }
        if (child.isPresent() && (configFile = new File(child.get(), CONFIG_YAML)).exists()) {
            URI uri = configFile.toURI();
            this.configurationFiles.put(app, uri);
            if (!this.configurationFiles.containsKey(DEFAULT_CONFIGURATION_FILE_KEY)) {
                this.configurationFiles.put(DEFAULT_CONFIGURATION_FILE_KEY, uri);
            }
            return uri;
        }
        return null;
    }

    private static class AppWalker
    extends DirectoryWalker<File> {
        private AppWalker() {
        }

        public List<File> getAppDirs(File base) throws IOException {
            ArrayList<File> results = new ArrayList<File>();
            this.walk(base, results);
            return results;
        }

        protected boolean handleDirectory(File directory, int depth, Collection<File> results) {
            File configFile = new File(directory, ServletMapPrinterFactory.CONFIG_YAML);
            if (configFile.exists()) {
                results.add(directory);
            }
            return depth < 2;
        }
    }
}

