/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import java.net.URL;
import org.geotools.ows.wms.WMS1_0_0;
import org.geotools.ows.wms.WMS1_1_0;
import org.geotools.ows.wms.WMS1_1_1;
import org.geotools.ows.wms.WMS1_3_0;
import org.geotools.ows.wms.request.GetMapRequest;

public enum WmsVersion {
    V1_0_0{

        @Override
        public GetMapRequest getGetMapRequest(URL baseURL) {
            return new WMS1_0_0.GetMapRequest(baseURL);
        }
    }
    ,
    V1_1_0{

        @Override
        public GetMapRequest getGetMapRequest(URL baseURL) {
            return new WMS1_1_0.GetMapRequest(baseURL);
        }
    }
    ,
    V1_1_1{

        @Override
        public GetMapRequest getGetMapRequest(URL baseURL) {
            return new WMS1_1_1.GetMapRequest(baseURL);
        }
    }
    ,
    V1_3_0{

        @Override
        public GetMapRequest getGetMapRequest(URL baseURL) {
            return new WMS1_3_0.GetMapRequest(baseURL);
        }
    };


    public static WmsVersion lookup(String versionString) {
        for (WmsVersion wmsVersion : WmsVersion.values()) {
            if (!versionString.equals(wmsVersion.versionString())) continue;
            return wmsVersion;
        }
        StringBuilder msg = new StringBuilder("\n'").append(versionString).append("' is not one of the supported WMS versions.  Supported versions include: ");
        for (WmsVersion wmsVersion : WmsVersion.values()) {
            msg.append("\n\t* ").append(wmsVersion.versionString());
        }
        throw new IllegalArgumentException(msg.toString());
    }

    public String versionString() {
        return this.name().substring(1).replace('_', '.');
    }

    public abstract GetMapRequest getGetMapRequest(URL var1);
}

