/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.servlet.job.Accounting;
import org.mapfish.print.servlet.job.HibernateAccountingEntry;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class HibernateAccounting
extends Accounting {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateAccounting.class);
    @Autowired
    private SessionFactory sf;
    @Autowired
    private PlatformTransactionManager txManager;

    @Override
    public JobTracker startJob(PrintJobEntry entry, Configuration configuration) {
        return new JobTracker(entry, configuration);
    }

    public class JobTracker
    extends Accounting.JobTracker {
        protected JobTracker(PrintJobEntry entry, Configuration configuration) {
            super(HibernateAccounting.this, entry, configuration);
        }

        @Override
        public long onJobSuccess(PrintJob.PrintResult printResult) {
            HibernateAccountingEntry record1;
            long duractionUSec = super.onJobSuccess(printResult);
            HibernateAccountingEntry record = record1 = new HibernateAccountingEntry(this.entry, PrintJobStatus.Status.FINISHED, this.configuration);
            record.setProcessingTimeMS(duractionUSec / 1000000L);
            record.setFileSize(printResult.fileSize);
            record.setStats(printResult.executionContext.getStats());
            this.insertRecord(record);
            return duractionUSec;
        }

        @Override
        public void onJobCancel() {
            super.onJobCancel();
            HibernateAccountingEntry record = new HibernateAccountingEntry(this.entry, PrintJobStatus.Status.CANCELLED, this.configuration);
            this.insertRecord(record);
        }

        @Override
        public void onJobError() {
            super.onJobError();
            HibernateAccountingEntry record = new HibernateAccountingEntry(this.entry, PrintJobStatus.Status.ERROR, this.configuration);
            this.insertRecord(record);
        }

        private void insertRecord(final HibernateAccountingEntry tuple) {
            try {
                TransactionTemplate tmpl = new TransactionTemplate(HibernateAccounting.this.txManager);
                tmpl.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        Session currentSession = HibernateAccounting.this.sf.getCurrentSession();
                        currentSession.merge((Object)tuple);
                        currentSession.flush();
                        currentSession.evict((Object)tuple);
                    }
                });
            }
            catch (HibernateException ex) {
                LOGGER.warn("Cannot save accounting information", (Throwable)ex);
            }
        }
    }
}

