/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl.hibernate;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.LockMode;
import org.hibernate.PessimisticLockException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.hibernate.PrintJobResultExtImpl;
import org.mapfish.print.servlet.job.impl.hibernate.PrintJobStatusExtImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class PrintJobDao {
    @Autowired
    private SessionFactory sf;

    @PostConstruct
    public final void init() {
        this.sf.openSession();
    }

    private Session getSession() {
        return this.sf.getCurrentSession();
    }

    public final void save(PrintJobStatusExtImpl entry) {
        this.getSession().merge((Object)entry);
        this.getSession().flush();
        this.getSession().evict((Object)entry);
    }

    @Nullable
    public final PrintJobStatusExtImpl get(String id) {
        PrintJobStatusExtImpl result = this.get(id, false);
        if (result != null) {
            this.getSession().evict((Object)result);
        }
        return result;
    }

    @Nullable
    public final PrintJobStatusExtImpl get(String id, boolean lock) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PrintJobStatusExtImpl.class);
        Root root = criteria.from(PrintJobStatusExtImpl.class);
        root.alias("pj");
        root.fetch("result", JoinType.LEFT);
        criteria.where((Expression)builder.equal((Expression)root.get("referenceId"), (Object)id));
        Query query = this.getSession().createQuery(criteria);
        if (lock) {
            query.setLockMode("pj", LockMode.PESSIMISTIC_READ);
        } else {
            query.setReadOnly(true);
        }
        return (PrintJobStatusExtImpl)query.uniqueResult();
    }

    public final Object getValue(String id, String property) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Object.class);
        Root root = criteria.from(PrintJobStatusExtImpl.class);
        criteria.select((Selection)root.get(property));
        criteria.where((Expression)builder.equal((Expression)root.get("referenceId"), (Object)id));
        return this.getSession().createQuery(criteria).uniqueResult();
    }

    public final long count(PrintJobStatus.Status ... statuses) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(PrintJobStatusExtImpl.class);
        criteria.select((Selection)builder.count((Expression)root));
        if (statuses.length > 0) {
            criteria.where((Expression)root.get("status").in(Arrays.asList(statuses)));
        }
        return (Long)this.getSession().createQuery(criteria).uniqueResult();
    }

    public final List<PrintJobStatusExtImpl> get(PrintJobStatus.Status ... statuses) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PrintJobStatusExtImpl.class);
        Root root = criteria.from(PrintJobStatusExtImpl.class);
        if (statuses.length > 0) {
            criteria.where((Expression)root.get("status").in(Arrays.asList(statuses)));
        }
        return this.getSession().createQuery(criteria).list();
    }

    public final long getTotalTimeSpentPrinting() {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(PrintJobStatusExtImpl.class);
        criteria.where((Expression)root.get("completionTime").isNotNull());
        criteria.select((Selection)builder.sum(builder.diff((Expression)root.get("completionTime"), (Expression)root.get("entry").get("startTime"))));
        Long result = (Long)this.getSession().createQuery(criteria).uniqueResult();
        return result != null ? result : 0L;
    }

    public final void cancelOld(long starttimeThreshold, long checkTimeThreshold, String message) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaUpdate update = builder.createCriteriaUpdate(PrintJobStatusExtImpl.class);
        Root root = update.from(PrintJobStatusExtImpl.class);
        update.where((Expression)builder.and((Expression)builder.equal((Expression)root.get("status"), (Object)PrintJobStatus.Status.WAITING), (Expression)builder.or((Expression)builder.lessThan((Expression)root.get("entry").get("startTime"), (Comparable)Long.valueOf(starttimeThreshold)), (Expression)builder.and((Expression)builder.isNotNull((Expression)root.get("lastCheckTime")), (Expression)builder.lessThan((Expression)root.get("lastCheckTime"), (Comparable)Long.valueOf(checkTimeThreshold))))));
        update.set(root.get("status"), (Object)PrintJobStatus.Status.CANCELLED);
        update.set(root.get("error"), (Object)message);
        this.getSession().createQuery(update).executeUpdate();
    }

    public final void updateLastCheckTime(String id, long lastCheckTime) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaUpdate update = builder.createCriteriaUpdate(PrintJobStatusExtImpl.class);
        Root root = update.from(PrintJobStatusExtImpl.class);
        update.where((Expression)builder.equal((Expression)root.get("referenceId"), (Object)id));
        update.set(root.get("lastCheckTime"), (Object)lastCheckTime);
        this.getSession().createQuery(update).executeUpdate();
    }

    public final int deleteOld(long checkTimeThreshold) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(PrintJobStatusExtImpl.class);
        Root root = delete.from(PrintJobStatusExtImpl.class);
        delete.where((Expression)builder.and((Expression)builder.isNotNull((Expression)root.get("lastCheckTime")), (Expression)builder.lessThan((Expression)root.get("lastCheckTime"), (Comparable)Long.valueOf(checkTimeThreshold))));
        return this.getSession().createQuery(delete).executeUpdate();
    }

    public final List<PrintJobStatusExtImpl> poll(int size) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PrintJobStatusExtImpl.class);
        Root root = criteria.from(PrintJobStatusExtImpl.class);
        root.alias("pj");
        criteria.where((Expression)builder.equal((Expression)root.get("status"), (Object)PrintJobStatus.Status.WAITING));
        criteria.orderBy(new Order[]{builder.asc((Expression)root.get("entry").get("startTime"))});
        Query query = this.getSession().createQuery(criteria);
        query.setMaxResults(size);
        query.setLockMode("pj", LockMode.UPGRADE_NOWAIT);
        try {
            return query.getResultList();
        }
        catch (PessimisticLockException ex) {
            return Collections.emptyList();
        }
    }

    public final PrintJobResultExtImpl getResult(URI reportURI) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(PrintJobResultExtImpl.class);
        Root root = criteria.from(PrintJobResultExtImpl.class);
        criteria.where((Expression)builder.equal((Expression)root.get("reportURI"), (Object)reportURI.toString()));
        return (PrintJobResultExtImpl)this.getSession().createQuery(criteria).uniqueResult();
    }

    public void delete(String referenceId) {
        CriteriaBuilder builder = this.getSession().getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(PrintJobStatusExtImpl.class);
        Root root = delete.from(PrintJobStatusExtImpl.class);
        delete.where((Expression)builder.equal((Expression)root.get("referenceId"), (Object)referenceId));
        this.getSession().createQuery(delete).executeUpdate();
    }
}

