/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.util.Map;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.config.HasConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;

public final class MapfishPrintConstructor
extends Constructor {
    private static final String CONFIGURATION_TAG = "configuration";
    private static final ThreadLocal<Configuration> CONFIGURATION_UNDER_CONSTRUCTION = new InheritableThreadLocal<Configuration>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MapfishPrintConstructor.class);
    private final ConfigurableApplicationContext context;

    public MapfishPrintConstructor(ConfigurableApplicationContext context) {
        super(new TypeDescription(Configuration.class, CONFIGURATION_TAG));
        this.context = context;
        Map yamlObjects = context.getBeansOfType(ConfigurationObject.class);
        for (Map.Entry entry : yamlObjects.entrySet()) {
            BeanDefinition beanDefinition = context.getBeanFactory().getBeanDefinition((String)entry.getKey());
            if (!beanDefinition.isPrototype()) {
                String message = "Error: Spring bean: " + (String)entry.getKey() + " is not defined as scope = prototype";
                LOGGER.error(message);
                throw new AssertionError((Object)message);
            }
            this.addTypeDescription(new TypeDescription(((ConfigurationObject)entry.getValue()).getClass(), "!" + (String)entry.getKey()));
        }
    }

    static void setConfigurationUnderConstruction(Configuration config) {
        CONFIGURATION_UNDER_CONSTRUCTION.set(config);
    }

    protected Object newInstance(Node node) {
        Object bean;
        if (node.getType() == Configuration.class) {
            return CONFIGURATION_UNDER_CONSTRUCTION.get();
        }
        try {
            bean = this.context.getBean(node.getTag().getValue().substring(1));
        }
        catch (NoSuchBeanDefinitionException e) {
            bean = this.context.getBean(node.getType());
        }
        if (bean instanceof HasConfiguration) {
            ((HasConfiguration)bean).setConfiguration(CONFIGURATION_UNDER_CONSTRUCTION.get());
        }
        return bean;
    }
}

