/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.json.JSONObject;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.ParserPluginUtils;
import org.mapfish.print.map.style.SLDParserPlugin;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.mapfish.print.map.style.json.MapfishJsonStyleVersion1;
import org.mapfish.print.map.style.json.MapfishJsonStyleVersion2;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.http.client.ClientHttpRequestFactory;

public final class MapfishStyleParserPlugin
implements StyleParserPlugin {
    static final String JSON_VERSION = "version";
    private StyleBuilder sldStyleBuilder = new StyleBuilder();

    @Override
    public Optional<Style> parseStyle(@Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory, @Nonnull String styleString) {
        Optional<Style> styleOptional = this.tryParse(configuration, styleString, clientHttpRequestFactory);
        if (styleOptional.isPresent()) {
            return styleOptional;
        }
        return ParserPluginUtils.loadStyleAsURI(clientHttpRequestFactory, styleString, input -> {
            try {
                return this.tryParse(configuration, new String((byte[])input, Constants.DEFAULT_CHARSET), clientHttpRequestFactory);
            }
            catch (Throwable e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        });
    }

    private Optional<Style> tryParse(@Nullable Configuration configuration, @Nonnull String styleString, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory) {
        String trimmed = styleString.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            PJsonObject json = new PJsonObject(new JSONObject(styleString), "style");
            String jsonVersion = json.optString(JSON_VERSION, "1");
            for (Versions version : Versions.values()) {
                if (!version.versionNumber.equals(jsonVersion)) continue;
                return Optional.of(version.parseStyle(json, this.sldStyleBuilder, configuration, clientHttpRequestFactory));
            }
        } else if (trimmed.startsWith("<") && trimmed.endsWith(">")) {
            SLDParserPlugin parser = new SLDParserPlugin();
            return parser.parseStyle(configuration, clientHttpRequestFactory, styleString);
        }
        return Optional.empty();
    }

    static enum Versions {
        ONE("1"){

            @Override
            Style parseStyle(@Nonnull PJsonObject json, @Nonnull StyleBuilder styleBuilder, @Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory requestFactory) {
                return new MapfishJsonStyleVersion1(json, styleBuilder, configuration, requestFactory, "geometry").parseStyle();
            }
        }
        ,
        TWO("2"){

            @Override
            Style parseStyle(@Nonnull PJsonObject json, @Nonnull StyleBuilder styleBuilder, @Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory requestFactory) {
                return new MapfishJsonStyleVersion2(json, styleBuilder, configuration, requestFactory).parseStyle();
            }
        };

        private final String versionNumber;

        private Versions(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        abstract Style parseStyle(PJsonObject var1, StyleBuilder var2, Configuration var3, ClientHttpRequestFactory var4);
    }
}

