/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wmts;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.URIUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.wmts.Matrix;
import org.mapfish.print.map.tiled.wmts.RequestEncoding;
import org.mapfish.print.map.tiled.wmts.WMTSLayerParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public class WMTSLayer
extends AbstractTiledLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMTSLayer.class);
    private final WMTSLayerParam param;

    protected WMTSLayer(@Nullable ForkJoinPool forkJoinPool, @Nullable StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull WMTSLayerParam param, @Nullable MetricRegistry registry, @Nonnull Configuration configuration) {
        super(forkJoinPool, styleSupplier, param, registry, configuration);
        this.param = param;
    }

    public static URI createRestURI(String matrixId, int row, int col, WMTSLayerParam layerParam) throws URISyntaxException {
        String path = layerParam.baseURL;
        if (layerParam.dimensions != null) {
            for (int i = 0; i < layerParam.dimensions.length; ++i) {
                String dimension = layerParam.dimensions[i];
                String value = layerParam.dimensionParams.optString(dimension);
                if (value == null) {
                    value = layerParam.dimensionParams.getString(dimension.toUpperCase());
                }
                path = path.replace("{" + dimension + "}", value);
            }
        }
        path = path.replace("{TileMatrixSet}", layerParam.matrixSet);
        path = path.replace("{TileMatrix}", matrixId);
        path = path.replace("{TileRow}", String.valueOf(row));
        path = path.replace("{TileCol}", String.valueOf(col));
        path = path.replace("{style}", layerParam.style);
        path = path.replace("{Layer}", layerParam.layer);
        return new URI(path);
    }

    @Override
    protected final TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi) {
        return new WMTSTileCacheInfo(bounds, paintArea, dpi);
    }

    @Override
    public final MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromMimeType(this.param.imageFormat);
    }

    @VisibleForTesting
    final class WMTSTileCacheInfo
    extends TileCacheInformation {
        private Matrix matrix;

        private WMTSTileCacheInfo(MapBounds bounds, Rectangle paintArea, double dpi) {
            super(bounds, paintArea, dpi, WMTSLayer.this.param);
            double diff = Double.POSITIVE_INFINITY;
            double targetResolution = bounds.getScale(paintArea, dpi).getResolution();
            for (Matrix m : ((WMTSLayer)WMTSLayer.this).param.matrices) {
                double resolution = m.getResolution(this.bounds.getProjection());
                double delta = Math.abs(resolution - targetResolution);
                if (!(delta < diff)) continue;
                diff = delta;
                this.matrix = m;
                WMTSLayer.this.imageBufferScaling = targetResolution / resolution;
            }
            if (this.matrix == null) {
                throw new IllegalArgumentException("Unable to find a matrix for the resolution: " + targetResolution);
            }
        }

        @Override
        @Nonnull
        public Dimension getTileSize() {
            int width = this.matrix.getTileWidth();
            int height = this.matrix.getTileHeight();
            return new Dimension(width, height);
        }

        @Override
        @Nonnull
        protected ReferencedEnvelope getTileCacheBounds() {
            double resolution = this.getResolution();
            double minX = this.matrix.topLeftCorner[0];
            double tileHeight = this.matrix.getTileHeight();
            double numYTiles = this.matrix.matrixSize[1];
            double minY = this.matrix.topLeftCorner[1] - tileHeight * numYTiles * resolution;
            double tileWidth = this.matrix.getTileWidth();
            double numXTiles = this.matrix.matrixSize[0];
            double maxX = this.matrix.topLeftCorner[0] + tileWidth * numXTiles * resolution;
            double maxY = this.matrix.topLeftCorner[1];
            return new ReferencedEnvelope(minX, maxX, minY, maxY, this.bounds.getProjection());
        }

        @Override
        @Nonnull
        public ClientHttpRequest getTileRequest(MfClientHttpRequestFactory httpRequestFactory, String commonUrl, ReferencedEnvelope tileBounds, Dimension tileSizeOnScreen, int column, int row) throws URISyntaxException, IOException {
            URI uri;
            WMTSLayerParam layerParam = WMTSLayer.this.param;
            if (RequestEncoding.REST == layerParam.requestEncoding) {
                uri = WMTSLayer.createRestURI(this.matrix.identifier, row, column, layerParam);
            } else {
                URI commonUri = new URI(commonUrl);
                uri = this.createKVPUri(commonUri, row, column, layerParam);
            }
            return httpRequestFactory.createRequest(uri, HttpMethod.GET);
        }

        private URI createKVPUri(URI commonURI, int row, int col, WMTSLayerParam layerParam) {
            Multimap<String, String> queryParams = URIUtils.getParameters(commonURI);
            queryParams.put((Object)"SERVICE", (Object)"WMTS");
            queryParams.put((Object)"REQUEST", (Object)"GetTile");
            queryParams.put((Object)"VERSION", (Object)layerParam.version);
            queryParams.put((Object)"LAYER", (Object)layerParam.layer);
            queryParams.put((Object)"STYLE", (Object)layerParam.style);
            queryParams.put((Object)"TILEMATRIXSET", (Object)layerParam.matrixSet);
            queryParams.put((Object)"TILEMATRIX", (Object)this.matrix.identifier);
            queryParams.put((Object)"TILEROW", (Object)String.valueOf(row));
            queryParams.put((Object)"TILECOL", (Object)String.valueOf(col));
            queryParams.put((Object)"FORMAT", (Object)layerParam.imageFormat);
            if (layerParam.dimensions != null) {
                for (int i = 0; i < layerParam.dimensions.length; ++i) {
                    String d = layerParam.dimensions[i];
                    String dimensionValue = layerParam.dimensionParams.optString(d);
                    if (dimensionValue == null) {
                        dimensionValue = layerParam.dimensionParams.getString(d.toUpperCase());
                    }
                    queryParams.put((Object)d, (Object)dimensionValue);
                }
            }
            URI uri = URIUtils.setQueryParams(commonURI, queryParams);
            return uri;
        }

        @Override
        public double getResolution() {
            return this.matrix.getResolution(this.bounds.getProjection());
        }

        @Override
        public Double getLayerDpi() {
            return 90.7142857142857;
        }
    }
}

