/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import java.awt.Graphics2D;
import org.mapfish.print.processor.map.scalebar.ScaleBarRenderSettings;
import org.mapfish.print.processor.map.scalebar.ScalebarDrawer;

public class LineScalebarDrawer
extends ScalebarDrawer {
    public LineScalebarDrawer(Graphics2D graphics2d, ScaleBarRenderSettings settings) {
        super(graphics2d, settings);
    }

    @Override
    protected final void drawBar() {
        int barSize = this.getSettings().getBarSize();
        this.getGraphics2d().drawLine(0, -barSize, 0, 0);
        int intervalsLength = Math.round(this.getSettings().getIntervalLengthInPixels() * (float)this.getParams().intervals.intValue());
        this.getGraphics2d().drawLine(0, -barSize, intervalsLength, -barSize);
        this.getGraphics2d().drawLine(intervalsLength, -barSize, intervalsLength, 0);
        for (int i = 0; i < this.getParams().intervals; ++i) {
            float pos = (float)i * this.getSettings().getIntervalLengthInPixels();
            if (i > 0) {
                this.getGraphics2d().drawLine(Math.round(pos), 0, Math.round(pos), -barSize);
            }
            for (int j = 1; j < this.getSettings().getNumSubIntervals(); ++j) {
                this.getGraphics2d().drawLine(Math.round(pos += this.getSettings().getIntervalLengthInPixels() / (float)this.getSettings().getNumSubIntervals()), -barSize, Math.round(pos), -Math.round((float)barSize / 2.0f));
            }
        }
    }
}

