/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import org.mapfish.print.attribute.PrimitiveAttribute;

public class StringAttribute
extends PrimitiveAttribute<String> {
    private int maxLength = -1;

    public StringAttribute() {
        super(String.class);
    }

    @Override
    public final void setDefault(String value) {
        this.defaultValue = value;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public final void validateValue(Object value) {
        String text;
        if (this.maxLength >= 0 && value instanceof String && (text = (String)value).length() > this.maxLength) {
            throw new IllegalArgumentException("text contains more than " + this.maxLength + " characters");
        }
    }

    @Override
    public Class getValueType() {
        return String.class;
    }
}

