/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.annotation.PostConstruct;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.MapfishPrintConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);
    @Autowired
    private ConfigurableApplicationContext context;
    private Yaml yaml;
    private boolean doValidation = true;

    @PostConstruct
    public final void init() {
        MapfishPrintConstructor constructor = new MapfishPrintConstructor(this.context);
        this.yaml = new Yaml((BaseConstructor)constructor);
    }

    @VisibleForTesting
    public final Configuration getConfig(File configFile) throws IOException {
        try (FileInputStream in = new FileInputStream(configFile);){
            Configuration configuration = this.getConfig(configFile, in);
            return configuration;
        }
    }

    public final Configuration getConfig(File configFile, InputStream configData) throws IOException {
        List<Throwable> validate;
        Configuration configuration = (Configuration)this.context.getBean(Configuration.class);
        configuration.setConfigurationFile(configFile);
        MapfishPrintConstructor.setConfigurationUnderConstruction(configuration);
        Configuration config = (Configuration)this.yaml.load((Reader)new InputStreamReader(configData, "UTF-8"));
        if (this.doValidation && !(validate = config.validate()).isEmpty()) {
            StringBuilder errors = new StringBuilder();
            for (Throwable throwable : validate) {
                errors.append("\n\t* ").append(throwable.getMessage());
                LOGGER.error("Configuration Error found", throwable);
            }
            throw new Error(errors.toString(), validate.get(0));
        }
        return config;
    }

    public final void setDoValidation(boolean doValidation) {
        this.doValidation = doValidation;
    }
}

